/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Alexa Skill configuration of a SIP media application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SipMediaApplicationAlexaSkillConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SipMediaApplicationAlexaSkillConfiguration.Builder, SipMediaApplicationAlexaSkillConfiguration> {
    private static final SdkField<String> ALEXA_SKILL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlexaSkillStatus").getter(getter(SipMediaApplicationAlexaSkillConfiguration::alexaSkillStatusAsString))
            .setter(setter(Builder::alexaSkillStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlexaSkillStatus").build()).build();

    private static final SdkField<List<String>> ALEXA_SKILL_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AlexaSkillIds")
            .getter(getter(SipMediaApplicationAlexaSkillConfiguration::alexaSkillIds))
            .setter(setter(Builder::alexaSkillIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlexaSkillIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALEXA_SKILL_STATUS_FIELD,
            ALEXA_SKILL_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alexaSkillStatus;

    private final List<String> alexaSkillIds;

    private SipMediaApplicationAlexaSkillConfiguration(BuilderImpl builder) {
        this.alexaSkillStatus = builder.alexaSkillStatus;
        this.alexaSkillIds = builder.alexaSkillIds;
    }

    /**
     * <p>
     * The status of the Alexa Skill configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alexaSkillStatus}
     * will return {@link AlexaSkillStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #alexaSkillStatusAsString}.
     * </p>
     * 
     * @return The status of the Alexa Skill configuration.
     * @see AlexaSkillStatus
     */
    public final AlexaSkillStatus alexaSkillStatus() {
        return AlexaSkillStatus.fromValue(alexaSkillStatus);
    }

    /**
     * <p>
     * The status of the Alexa Skill configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alexaSkillStatus}
     * will return {@link AlexaSkillStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #alexaSkillStatusAsString}.
     * </p>
     * 
     * @return The status of the Alexa Skill configuration.
     * @see AlexaSkillStatus
     */
    public final String alexaSkillStatusAsString() {
        return alexaSkillStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlexaSkillIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlexaSkillIds() {
        return alexaSkillIds != null && !(alexaSkillIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the Alexa Skill configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlexaSkillIds} method.
     * </p>
     * 
     * @return The ID of the Alexa Skill configuration.
     */
    public final List<String> alexaSkillIds() {
        return alexaSkillIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alexaSkillStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAlexaSkillIds() ? alexaSkillIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SipMediaApplicationAlexaSkillConfiguration)) {
            return false;
        }
        SipMediaApplicationAlexaSkillConfiguration other = (SipMediaApplicationAlexaSkillConfiguration) obj;
        return Objects.equals(alexaSkillStatusAsString(), other.alexaSkillStatusAsString())
                && hasAlexaSkillIds() == other.hasAlexaSkillIds() && Objects.equals(alexaSkillIds(), other.alexaSkillIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SipMediaApplicationAlexaSkillConfiguration").add("AlexaSkillStatus", alexaSkillStatusAsString())
                .add("AlexaSkillIds", alexaSkillIds() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlexaSkillStatus":
            return Optional.ofNullable(clazz.cast(alexaSkillStatusAsString()));
        case "AlexaSkillIds":
            return Optional.ofNullable(clazz.cast(alexaSkillIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SipMediaApplicationAlexaSkillConfiguration, T> g) {
        return obj -> g.apply((SipMediaApplicationAlexaSkillConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SipMediaApplicationAlexaSkillConfiguration> {
        /**
         * <p>
         * The status of the Alexa Skill configuration.
         * </p>
         * 
         * @param alexaSkillStatus
         *        The status of the Alexa Skill configuration.
         * @see AlexaSkillStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlexaSkillStatus
         */
        Builder alexaSkillStatus(String alexaSkillStatus);

        /**
         * <p>
         * The status of the Alexa Skill configuration.
         * </p>
         * 
         * @param alexaSkillStatus
         *        The status of the Alexa Skill configuration.
         * @see AlexaSkillStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlexaSkillStatus
         */
        Builder alexaSkillStatus(AlexaSkillStatus alexaSkillStatus);

        /**
         * <p>
         * The ID of the Alexa Skill configuration.
         * </p>
         * 
         * @param alexaSkillIds
         *        The ID of the Alexa Skill configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alexaSkillIds(Collection<String> alexaSkillIds);

        /**
         * <p>
         * The ID of the Alexa Skill configuration.
         * </p>
         * 
         * @param alexaSkillIds
         *        The ID of the Alexa Skill configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alexaSkillIds(String... alexaSkillIds);
    }

    static final class BuilderImpl implements Builder {
        private String alexaSkillStatus;

        private List<String> alexaSkillIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SipMediaApplicationAlexaSkillConfiguration model) {
            alexaSkillStatus(model.alexaSkillStatus);
            alexaSkillIds(model.alexaSkillIds);
        }

        public final String getAlexaSkillStatus() {
            return alexaSkillStatus;
        }

        public final void setAlexaSkillStatus(String alexaSkillStatus) {
            this.alexaSkillStatus = alexaSkillStatus;
        }

        @Override
        public final Builder alexaSkillStatus(String alexaSkillStatus) {
            this.alexaSkillStatus = alexaSkillStatus;
            return this;
        }

        @Override
        public final Builder alexaSkillStatus(AlexaSkillStatus alexaSkillStatus) {
            this.alexaSkillStatus(alexaSkillStatus == null ? null : alexaSkillStatus.toString());
            return this;
        }

        public final Collection<String> getAlexaSkillIds() {
            if (alexaSkillIds instanceof SdkAutoConstructList) {
                return null;
            }
            return alexaSkillIds;
        }

        public final void setAlexaSkillIds(Collection<String> alexaSkillIds) {
            this.alexaSkillIds = AlexaSkillIdListCopier.copy(alexaSkillIds);
        }

        @Override
        public final Builder alexaSkillIds(Collection<String> alexaSkillIds) {
            this.alexaSkillIds = AlexaSkillIdListCopier.copy(alexaSkillIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alexaSkillIds(String... alexaSkillIds) {
            alexaSkillIds(Arrays.asList(alexaSkillIds));
            return this;
        }

        @Override
        public SipMediaApplicationAlexaSkillConfiguration build() {
            return new SipMediaApplicationAlexaSkillConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
