/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVoiceProfileRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<DeleteVoiceProfileRequest.Builder, DeleteVoiceProfileRequest> {
    private static final SdkField<String> VOICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceProfileId").getter(getter(DeleteVoiceProfileRequest::voiceProfileId))
            .setter(setter(Builder::voiceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VoiceProfileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_PROFILE_ID_FIELD));

    private final String voiceProfileId;

    private DeleteVoiceProfileRequest(BuilderImpl builder) {
        super(builder);
        this.voiceProfileId = builder.voiceProfileId;
    }

    /**
     * <p>
     * The voice profile ID.
     * </p>
     * 
     * @return The voice profile ID.
     */
    public final String voiceProfileId() {
        return voiceProfileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVoiceProfileRequest)) {
            return false;
        }
        DeleteVoiceProfileRequest other = (DeleteVoiceProfileRequest) obj;
        return Objects.equals(voiceProfileId(), other.voiceProfileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVoiceProfileRequest").add("VoiceProfileId", voiceProfileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceProfileId":
            return Optional.ofNullable(clazz.cast(voiceProfileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVoiceProfileRequest, T> g) {
        return obj -> g.apply((DeleteVoiceProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVoiceProfileRequest> {
        /**
         * <p>
         * The voice profile ID.
         * </p>
         * 
         * @param voiceProfileId
         *        The voice profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileId(String voiceProfileId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String voiceProfileId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVoiceProfileRequest model) {
            super(model);
            voiceProfileId(model.voiceProfileId);
        }

        public final String getVoiceProfileId() {
            return voiceProfileId;
        }

        public final void setVoiceProfileId(String voiceProfileId) {
            this.voiceProfileId = voiceProfileId;
        }

        @Override
        public final Builder voiceProfileId(String voiceProfileId) {
            this.voiceProfileId = voiceProfileId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVoiceProfileRequest build() {
            return new DeleteVoiceProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
