/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceAsyncClient;
import software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse;

public class SearchAvailablePhoneNumbersPublisher
implements SdkPublisher<SearchAvailablePhoneNumbersResponse> {
    private final ChimeSdkVoiceAsyncClient client;
    private final SearchAvailablePhoneNumbersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchAvailablePhoneNumbersPublisher(ChimeSdkVoiceAsyncClient client, SearchAvailablePhoneNumbersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchAvailablePhoneNumbersPublisher(ChimeSdkVoiceAsyncClient client, SearchAvailablePhoneNumbersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchAvailablePhoneNumbersResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchAvailablePhoneNumbersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchAvailablePhoneNumbersResponseFetcher
    implements AsyncPageFetcher<SearchAvailablePhoneNumbersResponse> {
        private SearchAvailablePhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(SearchAvailablePhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchAvailablePhoneNumbersResponse> nextPage(SearchAvailablePhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return SearchAvailablePhoneNumbersPublisher.this.client.searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersPublisher.this.firstRequest);
            }
            return SearchAvailablePhoneNumbersPublisher.this.client.searchAvailablePhoneNumbers((SearchAvailablePhoneNumbersRequest)((Object)SearchAvailablePhoneNumbersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

