/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBanSummary;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBanSummaryListCopier;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelBansResponse
extends ChimeSdkMessagingResponse
implements ToCopyableBuilder<Builder, ListChannelBansResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(ListChannelBansResponse.getter(ListChannelBansResponse::channelArn)).setter(ListChannelBansResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChannelBansResponse.getter(ListChannelBansResponse::nextToken)).setter(ListChannelBansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ChannelBanSummary>> CHANNEL_BANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelBans").getter(ListChannelBansResponse.getter(ListChannelBansResponse::channelBans)).setter(ListChannelBansResponse.setter(Builder::channelBans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelBans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelBanSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, NEXT_TOKEN_FIELD, CHANNEL_BANS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListChannelBansResponse.memberNameToFieldInitializer();
    private final String channelArn;
    private final String nextToken;
    private final List<ChannelBanSummary> channelBans;

    private ListChannelBansResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.nextToken = builder.nextToken;
        this.channelBans = builder.channelBans;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasChannelBans() {
        return this.channelBans != null && !(this.channelBans instanceof SdkAutoConstructList);
    }

    public final List<ChannelBanSummary> channelBans() {
        return this.channelBans;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelBans() ? this.channelBans() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelBansResponse)) {
            return false;
        }
        ListChannelBansResponse other = (ListChannelBansResponse)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasChannelBans() == other.hasChannelBans() && Objects.equals(this.channelBans(), other.channelBans());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelBansResponse").add("ChannelArn", (Object)this.channelArn()).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ChannelBans", this.hasChannelBans() ? this.channelBans() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ChannelBans": {
                return Optional.ofNullable(clazz.cast(this.channelBans()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelArn", CHANNEL_ARN_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ChannelBans", CHANNEL_BANS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChannelBansResponse, T> g) {
        return obj -> g.apply((ListChannelBansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingResponse.BuilderImpl
    implements Builder {
        private String channelArn;
        private String nextToken;
        private List<ChannelBanSummary> channelBans = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelBansResponse model) {
            super(model);
            this.channelArn(model.channelArn);
            this.nextToken(model.nextToken);
            this.channelBans(model.channelBans);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ChannelBanSummary.Builder> getChannelBans() {
            List<ChannelBanSummary.Builder> result = ChannelBanSummaryListCopier.copyToBuilder(this.channelBans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelBans(Collection<ChannelBanSummary.BuilderImpl> channelBans) {
            this.channelBans = ChannelBanSummaryListCopier.copyFromBuilder(channelBans);
        }

        @Override
        public final Builder channelBans(Collection<ChannelBanSummary> channelBans) {
            this.channelBans = ChannelBanSummaryListCopier.copy(channelBans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelBans(ChannelBanSummary ... channelBans) {
            this.channelBans(Arrays.asList(channelBans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelBans(Consumer<ChannelBanSummary.Builder> ... channelBans) {
            this.channelBans(Stream.of(channelBans).map(c -> (ChannelBanSummary)((ChannelBanSummary.Builder)ChannelBanSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListChannelBansResponse build() {
            return new ListChannelBansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkMessagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelBansResponse> {
        public Builder channelArn(String var1);

        public Builder nextToken(String var1);

        public Builder channelBans(Collection<ChannelBanSummary> var1);

        public Builder channelBans(ChannelBanSummary ... var1);

        public Builder channelBans(Consumer<ChannelBanSummary.Builder> ... var1);
    }
}

