/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmessaging.model.Processor;
import software.amazon.awssdk.services.chimesdkmessaging.model.ProcessorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelFlow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelFlow> {
    private static final SdkField<String> CHANNEL_FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelFlowArn").getter(ChannelFlow.getter(ChannelFlow::channelFlowArn)).setter(ChannelFlow.setter(Builder::channelFlowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelFlowArn").build()}).build();
    private static final SdkField<List<Processor>> PROCESSORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Processors").getter(ChannelFlow.getter(ChannelFlow::processors)).setter(ChannelFlow.setter(Builder::processors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Processor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ChannelFlow.getter(ChannelFlow::name)).setter(ChannelFlow.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(ChannelFlow.getter(ChannelFlow::createdTimestamp)).setter(ChannelFlow.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(ChannelFlow.getter(ChannelFlow::lastUpdatedTimestamp)).setter(ChannelFlow.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FLOW_ARN_FIELD, PROCESSORS_FIELD, NAME_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChannelFlow.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String channelFlowArn;
    private final List<Processor> processors;
    private final String name;
    private final Instant createdTimestamp;
    private final Instant lastUpdatedTimestamp;

    private ChannelFlow(BuilderImpl builder) {
        this.channelFlowArn = builder.channelFlowArn;
        this.processors = builder.processors;
        this.name = builder.name;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    public final String channelFlowArn() {
        return this.channelFlowArn;
    }

    public final boolean hasProcessors() {
        return this.processors != null && !(this.processors instanceof SdkAutoConstructList);
    }

    public final List<Processor> processors() {
        return this.processors;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelFlowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessors() ? this.processors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelFlow)) {
            return false;
        }
        ChannelFlow other = (ChannelFlow)obj;
        return Objects.equals(this.channelFlowArn(), other.channelFlowArn()) && this.hasProcessors() == other.hasProcessors() && Objects.equals(this.processors(), other.processors()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelFlow").add("ChannelFlowArn", (Object)this.channelFlowArn()).add("Processors", this.hasProcessors() ? this.processors() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelFlowArn": {
                return Optional.ofNullable(clazz.cast(this.channelFlowArn()));
            }
            case "Processors": {
                return Optional.ofNullable(clazz.cast(this.processors()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelFlowArn", CHANNEL_FLOW_ARN_FIELD);
        map.put("Processors", PROCESSORS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelFlow, T> g) {
        return obj -> g.apply((ChannelFlow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelFlowArn;
        private List<Processor> processors = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Instant createdTimestamp;
        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelFlow model) {
            this.channelFlowArn(model.channelFlowArn);
            this.processors(model.processors);
            this.name(model.name);
            this.createdTimestamp(model.createdTimestamp);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getChannelFlowArn() {
            return this.channelFlowArn;
        }

        public final void setChannelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
        }

        @Override
        public final Builder channelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
            return this;
        }

        public final List<Processor.Builder> getProcessors() {
            List<Processor.Builder> result = ProcessorListCopier.copyToBuilder(this.processors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessors(Collection<Processor.BuilderImpl> processors) {
            this.processors = ProcessorListCopier.copyFromBuilder(processors);
        }

        @Override
        public final Builder processors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Processor ... processors) {
            this.processors(Arrays.asList(processors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Consumer<Processor.Builder> ... processors) {
            this.processors(Stream.of(processors).map(c -> (Processor)((Processor.Builder)Processor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public ChannelFlow build() {
            return new ChannelFlow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelFlow> {
        public Builder channelFlowArn(String var1);

        public Builder processors(Collection<Processor> var1);

        public Builder processors(Processor ... var1);

        public Builder processors(Consumer<Processor.Builder> ... var1);

        public Builder name(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastUpdatedTimestamp(Instant var1);
    }
}

