/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingResponse;
import software.amazon.awssdk.services.chimesdkmessaging.model.SubChannelSummary;
import software.amazon.awssdk.services.chimesdkmessaging.model.SubChannelSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSubChannelsResponse
extends ChimeSdkMessagingResponse
implements ToCopyableBuilder<Builder, ListSubChannelsResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(ListSubChannelsResponse.getter(ListSubChannelsResponse::channelArn)).setter(ListSubChannelsResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<List<SubChannelSummary>> SUB_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubChannels").getter(ListSubChannelsResponse.getter(ListSubChannelsResponse::subChannels)).setter(ListSubChannelsResponse.setter(Builder::subChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubChannels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubChannelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSubChannelsResponse.getter(ListSubChannelsResponse::nextToken)).setter(ListSubChannelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, SUB_CHANNELS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSubChannelsResponse.memberNameToFieldInitializer();
    private final String channelArn;
    private final List<SubChannelSummary> subChannels;
    private final String nextToken;

    private ListSubChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.subChannels = builder.subChannels;
        this.nextToken = builder.nextToken;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final boolean hasSubChannels() {
        return this.subChannels != null && !(this.subChannels instanceof SdkAutoConstructList);
    }

    public final List<SubChannelSummary> subChannels() {
        return this.subChannels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubChannels() ? this.subChannels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubChannelsResponse)) {
            return false;
        }
        ListSubChannelsResponse other = (ListSubChannelsResponse)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && this.hasSubChannels() == other.hasSubChannels() && Objects.equals(this.subChannels(), other.subChannels()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSubChannelsResponse").add("ChannelArn", (Object)this.channelArn()).add("SubChannels", this.hasSubChannels() ? this.subChannels() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "SubChannels": {
                return Optional.ofNullable(clazz.cast(this.subChannels()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelArn", CHANNEL_ARN_FIELD);
        map.put("SubChannels", SUB_CHANNELS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSubChannelsResponse, T> g) {
        return obj -> g.apply((ListSubChannelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingResponse.BuilderImpl
    implements Builder {
        private String channelArn;
        private List<SubChannelSummary> subChannels = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubChannelsResponse model) {
            super(model);
            this.channelArn(model.channelArn);
            this.subChannels(model.subChannels);
            this.nextToken(model.nextToken);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final List<SubChannelSummary.Builder> getSubChannels() {
            List<SubChannelSummary.Builder> result = SubChannelSummaryListCopier.copyToBuilder(this.subChannels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubChannels(Collection<SubChannelSummary.BuilderImpl> subChannels) {
            this.subChannels = SubChannelSummaryListCopier.copyFromBuilder(subChannels);
        }

        @Override
        public final Builder subChannels(Collection<SubChannelSummary> subChannels) {
            this.subChannels = SubChannelSummaryListCopier.copy(subChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subChannels(SubChannelSummary ... subChannels) {
            this.subChannels(Arrays.asList(subChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subChannels(Consumer<SubChannelSummary.Builder> ... subChannels) {
            this.subChannels(Stream.of(subChannels).map(c -> (SubChannelSummary)((SubChannelSummary.Builder)SubChannelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSubChannelsResponse build() {
            return new ListSubChannelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkMessagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSubChannelsResponse> {
        public Builder channelArn(String var1);

        public Builder subChannels(Collection<SubChannelSummary> var1);

        public Builder subChannels(SubChannelSummary ... var1);

        public Builder subChannels(Consumer<SubChannelSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

