/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMode;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelPrivacy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelAssociatedWithFlowSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelAssociatedWithFlowSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ChannelAssociatedWithFlowSummary.getter(ChannelAssociatedWithFlowSummary::name)).setter(ChannelAssociatedWithFlowSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(ChannelAssociatedWithFlowSummary.getter(ChannelAssociatedWithFlowSummary::channelArn)).setter(ChannelAssociatedWithFlowSummary.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(ChannelAssociatedWithFlowSummary.getter(ChannelAssociatedWithFlowSummary::modeAsString)).setter(ChannelAssociatedWithFlowSummary.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Privacy").getter(ChannelAssociatedWithFlowSummary.getter(ChannelAssociatedWithFlowSummary::privacyAsString)).setter(ChannelAssociatedWithFlowSummary.setter(Builder::privacy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privacy").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metadata").getter(ChannelAssociatedWithFlowSummary.getter(ChannelAssociatedWithFlowSummary::metadata)).setter(ChannelAssociatedWithFlowSummary.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CHANNEL_ARN_FIELD, MODE_FIELD, PRIVACY_FIELD, METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChannelAssociatedWithFlowSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String channelArn;
    private final String mode;
    private final String privacy;
    private final String metadata;

    private ChannelAssociatedWithFlowSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.channelArn = builder.channelArn;
        this.mode = builder.mode;
        this.privacy = builder.privacy;
        this.metadata = builder.metadata;
    }

    public final String name() {
        return this.name;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final ChannelMode mode() {
        return ChannelMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final ChannelPrivacy privacy() {
        return ChannelPrivacy.fromValue(this.privacy);
    }

    public final String privacyAsString() {
        return this.privacy;
    }

    public final String metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelAssociatedWithFlowSummary)) {
            return false;
        }
        ChannelAssociatedWithFlowSummary other = (ChannelAssociatedWithFlowSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.privacyAsString(), other.privacyAsString()) && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelAssociatedWithFlowSummary").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ChannelArn", (Object)this.channelArn()).add("Mode", (Object)this.modeAsString()).add("Privacy", (Object)this.privacyAsString()).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "Privacy": {
                return Optional.ofNullable(clazz.cast(this.privacyAsString()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("ChannelArn", CHANNEL_ARN_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("Privacy", PRIVACY_FIELD);
        map.put("Metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelAssociatedWithFlowSummary, T> g) {
        return obj -> g.apply((ChannelAssociatedWithFlowSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String channelArn;
        private String mode;
        private String privacy;
        private String metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelAssociatedWithFlowSummary model) {
            this.name(model.name);
            this.channelArn(model.channelArn);
            this.mode(model.mode);
            this.privacy(model.privacy);
            this.metadata(model.metadata);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ChannelMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getPrivacy() {
            return this.privacy;
        }

        public final void setPrivacy(String privacy) {
            this.privacy = privacy;
        }

        @Override
        public final Builder privacy(String privacy) {
            this.privacy = privacy;
            return this;
        }

        @Override
        public final Builder privacy(ChannelPrivacy privacy) {
            this.privacy(privacy == null ? null : privacy.toString());
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public ChannelAssociatedWithFlowSummary build() {
            return new ChannelAssociatedWithFlowSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelAssociatedWithFlowSummary> {
        public Builder name(String var1);

        public Builder channelArn(String var1);

        public Builder mode(String var1);

        public Builder mode(ChannelMode var1);

        public Builder privacy(String var1);

        public Builder privacy(ChannelPrivacy var1);

        public Builder metadata(String var1);
    }
}

