/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingResponse;
import software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutChannelExpirationSettingsResponse
extends ChimeSdkMessagingResponse
implements ToCopyableBuilder<Builder, PutChannelExpirationSettingsResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(PutChannelExpirationSettingsResponse.getter(PutChannelExpirationSettingsResponse::channelArn)).setter(PutChannelExpirationSettingsResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<ExpirationSettings> EXPIRATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExpirationSettings").getter(PutChannelExpirationSettingsResponse.getter(PutChannelExpirationSettingsResponse::expirationSettings)).setter(PutChannelExpirationSettingsResponse.setter(Builder::expirationSettings)).constructor(ExpirationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, EXPIRATION_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutChannelExpirationSettingsResponse.memberNameToFieldInitializer();
    private final String channelArn;
    private final ExpirationSettings expirationSettings;

    private PutChannelExpirationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.expirationSettings = builder.expirationSettings;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final ExpirationSettings expirationSettings() {
        return this.expirationSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutChannelExpirationSettingsResponse)) {
            return false;
        }
        PutChannelExpirationSettingsResponse other = (PutChannelExpirationSettingsResponse)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.expirationSettings(), other.expirationSettings());
    }

    public final String toString() {
        return ToString.builder((String)"PutChannelExpirationSettingsResponse").add("ChannelArn", (Object)this.channelArn()).add("ExpirationSettings", (Object)this.expirationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "ExpirationSettings": {
                return Optional.ofNullable(clazz.cast(this.expirationSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelArn", CHANNEL_ARN_FIELD);
        map.put("ExpirationSettings", EXPIRATION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutChannelExpirationSettingsResponse, T> g) {
        return obj -> g.apply((PutChannelExpirationSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingResponse.BuilderImpl
    implements Builder {
        private String channelArn;
        private ExpirationSettings expirationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutChannelExpirationSettingsResponse model) {
            super(model);
            this.channelArn(model.channelArn);
            this.expirationSettings(model.expirationSettings);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final ExpirationSettings.Builder getExpirationSettings() {
            return this.expirationSettings != null ? this.expirationSettings.toBuilder() : null;
        }

        public final void setExpirationSettings(ExpirationSettings.BuilderImpl expirationSettings) {
            this.expirationSettings = expirationSettings != null ? expirationSettings.build() : null;
        }

        @Override
        public final Builder expirationSettings(ExpirationSettings expirationSettings) {
            this.expirationSettings = expirationSettings;
            return this;
        }

        @Override
        public PutChannelExpirationSettingsResponse build() {
            return new PutChannelExpirationSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutChannelExpirationSettingsResponse> {
        public Builder channelArn(String var1);

        public Builder expirationSettings(ExpirationSettings var1);

        default public Builder expirationSettings(Consumer<ExpirationSettings.Builder> expirationSettings) {
            return this.expirationSettings((ExpirationSettings)((ExpirationSettings.Builder)ExpirationSettings.builder().applyMutation(expirationSettings)).build());
        }
    }
}

