/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticChannelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticChannelConfiguration> {
    private static final SdkField<Integer> MAXIMUM_SUB_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumSubChannels").getter(ElasticChannelConfiguration.getter(ElasticChannelConfiguration::maximumSubChannels)).setter(ElasticChannelConfiguration.setter(Builder::maximumSubChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumSubChannels").build()}).build();
    private static final SdkField<Integer> TARGET_MEMBERSHIPS_PER_SUB_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetMembershipsPerSubChannel").getter(ElasticChannelConfiguration.getter(ElasticChannelConfiguration::targetMembershipsPerSubChannel)).setter(ElasticChannelConfiguration.setter(Builder::targetMembershipsPerSubChannel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMembershipsPerSubChannel").build()}).build();
    private static final SdkField<Integer> MINIMUM_MEMBERSHIP_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumMembershipPercentage").getter(ElasticChannelConfiguration.getter(ElasticChannelConfiguration::minimumMembershipPercentage)).setter(ElasticChannelConfiguration.setter(Builder::minimumMembershipPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumMembershipPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_SUB_CHANNELS_FIELD, TARGET_MEMBERSHIPS_PER_SUB_CHANNEL_FIELD, MINIMUM_MEMBERSHIP_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ElasticChannelConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maximumSubChannels;
    private final Integer targetMembershipsPerSubChannel;
    private final Integer minimumMembershipPercentage;

    private ElasticChannelConfiguration(BuilderImpl builder) {
        this.maximumSubChannels = builder.maximumSubChannels;
        this.targetMembershipsPerSubChannel = builder.targetMembershipsPerSubChannel;
        this.minimumMembershipPercentage = builder.minimumMembershipPercentage;
    }

    public final Integer maximumSubChannels() {
        return this.maximumSubChannels;
    }

    public final Integer targetMembershipsPerSubChannel() {
        return this.targetMembershipsPerSubChannel;
    }

    public final Integer minimumMembershipPercentage() {
        return this.minimumMembershipPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumSubChannels());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetMembershipsPerSubChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumMembershipPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticChannelConfiguration)) {
            return false;
        }
        ElasticChannelConfiguration other = (ElasticChannelConfiguration)obj;
        return Objects.equals(this.maximumSubChannels(), other.maximumSubChannels()) && Objects.equals(this.targetMembershipsPerSubChannel(), other.targetMembershipsPerSubChannel()) && Objects.equals(this.minimumMembershipPercentage(), other.minimumMembershipPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"ElasticChannelConfiguration").add("MaximumSubChannels", (Object)this.maximumSubChannels()).add("TargetMembershipsPerSubChannel", (Object)this.targetMembershipsPerSubChannel()).add("MinimumMembershipPercentage", (Object)this.minimumMembershipPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaximumSubChannels": {
                return Optional.ofNullable(clazz.cast(this.maximumSubChannels()));
            }
            case "TargetMembershipsPerSubChannel": {
                return Optional.ofNullable(clazz.cast(this.targetMembershipsPerSubChannel()));
            }
            case "MinimumMembershipPercentage": {
                return Optional.ofNullable(clazz.cast(this.minimumMembershipPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("MaximumSubChannels", MAXIMUM_SUB_CHANNELS_FIELD);
        map.put("TargetMembershipsPerSubChannel", TARGET_MEMBERSHIPS_PER_SUB_CHANNEL_FIELD);
        map.put("MinimumMembershipPercentage", MINIMUM_MEMBERSHIP_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ElasticChannelConfiguration, T> g) {
        return obj -> g.apply((ElasticChannelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximumSubChannels;
        private Integer targetMembershipsPerSubChannel;
        private Integer minimumMembershipPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticChannelConfiguration model) {
            this.maximumSubChannels(model.maximumSubChannels);
            this.targetMembershipsPerSubChannel(model.targetMembershipsPerSubChannel);
            this.minimumMembershipPercentage(model.minimumMembershipPercentage);
        }

        public final Integer getMaximumSubChannels() {
            return this.maximumSubChannels;
        }

        public final void setMaximumSubChannels(Integer maximumSubChannels) {
            this.maximumSubChannels = maximumSubChannels;
        }

        @Override
        public final Builder maximumSubChannels(Integer maximumSubChannels) {
            this.maximumSubChannels = maximumSubChannels;
            return this;
        }

        public final Integer getTargetMembershipsPerSubChannel() {
            return this.targetMembershipsPerSubChannel;
        }

        public final void setTargetMembershipsPerSubChannel(Integer targetMembershipsPerSubChannel) {
            this.targetMembershipsPerSubChannel = targetMembershipsPerSubChannel;
        }

        @Override
        public final Builder targetMembershipsPerSubChannel(Integer targetMembershipsPerSubChannel) {
            this.targetMembershipsPerSubChannel = targetMembershipsPerSubChannel;
            return this;
        }

        public final Integer getMinimumMembershipPercentage() {
            return this.minimumMembershipPercentage;
        }

        public final void setMinimumMembershipPercentage(Integer minimumMembershipPercentage) {
            this.minimumMembershipPercentage = minimumMembershipPercentage;
        }

        @Override
        public final Builder minimumMembershipPercentage(Integer minimumMembershipPercentage) {
            this.minimumMembershipPercentage = minimumMembershipPercentage;
            return this;
        }

        public ElasticChannelConfiguration build() {
            return new ElasticChannelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticChannelConfiguration> {
        public Builder maximumSubChannels(Integer var1);

        public Builder targetMembershipsPerSubChannel(Integer var1);

        public Builder minimumMembershipPercentage(Integer var1);
    }
}

