/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelSummary;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelSummaryListCopier;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelsResponse
extends ChimeSdkMessagingResponse
implements ToCopyableBuilder<Builder, ListChannelsResponse> {
    private static final SdkField<List<ChannelSummary>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Channels").getter(ListChannelsResponse.getter(ListChannelsResponse::channels)).setter(ListChannelsResponse.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChannelsResponse.getter(ListChannelsResponse::nextToken)).setter(ListChannelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Channels", CHANNELS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ChannelSummary> channels;
    private final String nextToken;

    private ListChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.channels = builder.channels;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<ChannelSummary> channels() {
        return this.channels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelsResponse)) {
            return false;
        }
        ListChannelsResponse other = (ListChannelsResponse)((Object)obj);
        return this.hasChannels() == other.hasChannels() && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelsResponse").add("Channels", this.hasChannels() ? this.channels() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelsResponse, T> g) {
        return obj -> g.apply((ListChannelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingResponse.BuilderImpl
    implements Builder {
        private List<ChannelSummary> channels = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelsResponse model) {
            super(model);
            this.channels(model.channels);
            this.nextToken(model.nextToken);
        }

        public final List<ChannelSummary.Builder> getChannels() {
            List<ChannelSummary.Builder> result = ChannelSummaryListCopier.copyToBuilder(this.channels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannels(Collection<ChannelSummary.BuilderImpl> channels) {
            this.channels = ChannelSummaryListCopier.copyFromBuilder(channels);
        }

        @Override
        public final Builder channels(Collection<ChannelSummary> channels) {
            this.channels = ChannelSummaryListCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(ChannelSummary ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Consumer<ChannelSummary.Builder> ... channels) {
            this.channels(Stream.of(channels).map(c -> (ChannelSummary)((ChannelSummary.Builder)ChannelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChannelsResponse build() {
            return new ListChannelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelsResponse> {
        public Builder channels(Collection<ChannelSummary> var1);

        public Builder channels(ChannelSummary ... var1);

        public Builder channels(Consumer<ChannelSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

