/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FallbackAction {
    CONTINUE("CONTINUE"),
    ABORT("ABORT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FallbackAction> VALUE_MAP;
    private final String value;

    private FallbackAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FallbackAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FallbackAction> knownValues() {
        EnumSet<FallbackAction> knownValues = EnumSet.allOf(FallbackAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FallbackAction.class, FallbackAction::toString);
    }
}

