/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingAsyncClient;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse;

public class ListChannelModeratorsPublisher
implements SdkPublisher<ListChannelModeratorsResponse> {
    private final ChimeSdkMessagingAsyncClient client;
    private final ListChannelModeratorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelModeratorsPublisher(ChimeSdkMessagingAsyncClient client, ListChannelModeratorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelModeratorsPublisher(ChimeSdkMessagingAsyncClient client, ListChannelModeratorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelModeratorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelModeratorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListChannelModeratorsResponseFetcher
    implements AsyncPageFetcher<ListChannelModeratorsResponse> {
        private ListChannelModeratorsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelModeratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChannelModeratorsResponse> nextPage(ListChannelModeratorsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelModeratorsPublisher.this.client.listChannelModerators(ListChannelModeratorsPublisher.this.firstRequest);
            }
            return ListChannelModeratorsPublisher.this.client.listChannelModerators((ListChannelModeratorsRequest)((Object)ListChannelModeratorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

