/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.Processor;
import software.amazon.awssdk.services.chimesdkmessaging.model.ProcessorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChannelFlowRequest
extends ChimeSdkMessagingRequest
implements ToCopyableBuilder<Builder, UpdateChannelFlowRequest> {
    private static final SdkField<String> CHANNEL_FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelFlowArn").getter(UpdateChannelFlowRequest.getter(UpdateChannelFlowRequest::channelFlowArn)).setter(UpdateChannelFlowRequest.setter(Builder::channelFlowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelFlowArn").build()}).build();
    private static final SdkField<List<Processor>> PROCESSORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Processors").getter(UpdateChannelFlowRequest.getter(UpdateChannelFlowRequest::processors)).setter(UpdateChannelFlowRequest.setter(Builder::processors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Processor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateChannelFlowRequest.getter(UpdateChannelFlowRequest::name)).setter(UpdateChannelFlowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FLOW_ARN_FIELD, PROCESSORS_FIELD, NAME_FIELD));
    private final String channelFlowArn;
    private final List<Processor> processors;
    private final String name;

    private UpdateChannelFlowRequest(BuilderImpl builder) {
        super(builder);
        this.channelFlowArn = builder.channelFlowArn;
        this.processors = builder.processors;
        this.name = builder.name;
    }

    public final String channelFlowArn() {
        return this.channelFlowArn;
    }

    public final boolean hasProcessors() {
        return this.processors != null && !(this.processors instanceof SdkAutoConstructList);
    }

    public final List<Processor> processors() {
        return this.processors;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelFlowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessors() ? this.processors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelFlowRequest)) {
            return false;
        }
        UpdateChannelFlowRequest other = (UpdateChannelFlowRequest)((Object)obj);
        return Objects.equals(this.channelFlowArn(), other.channelFlowArn()) && this.hasProcessors() == other.hasProcessors() && Objects.equals(this.processors(), other.processors()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChannelFlowRequest").add("ChannelFlowArn", (Object)this.channelFlowArn()).add("Processors", this.hasProcessors() ? this.processors() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelFlowArn": {
                return Optional.ofNullable(clazz.cast(this.channelFlowArn()));
            }
            case "Processors": {
                return Optional.ofNullable(clazz.cast(this.processors()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelFlowRequest, T> g) {
        return obj -> g.apply((UpdateChannelFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingRequest.BuilderImpl
    implements Builder {
        private String channelFlowArn;
        private List<Processor> processors = DefaultSdkAutoConstructList.getInstance();
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelFlowRequest model) {
            super(model);
            this.channelFlowArn(model.channelFlowArn);
            this.processors(model.processors);
            this.name(model.name);
        }

        public final String getChannelFlowArn() {
            return this.channelFlowArn;
        }

        public final void setChannelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
        }

        @Override
        public final Builder channelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
            return this;
        }

        public final List<Processor.Builder> getProcessors() {
            List<Processor.Builder> result = ProcessorListCopier.copyToBuilder(this.processors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessors(Collection<Processor.BuilderImpl> processors) {
            this.processors = ProcessorListCopier.copyFromBuilder(processors);
        }

        @Override
        public final Builder processors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Processor ... processors) {
            this.processors(Arrays.asList(processors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Consumer<Processor.Builder> ... processors) {
            this.processors(Stream.of(processors).map(c -> (Processor)((Processor.Builder)Processor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelFlowRequest build() {
            return new UpdateChannelFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChannelFlowRequest> {
        public Builder channelFlowArn(String var1);

        public Builder processors(Collection<Processor> var1);

        public Builder processors(Processor ... var1);

        public Builder processors(Consumer<Processor.Builder> ... var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

