/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction;
import software.amazon.awssdk.services.chimesdkmessaging.model.ProcessorConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Processor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Processor> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Processor.getter(Processor::name)).setter(Processor.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<ProcessorConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(Processor.getter(Processor::configuration)).setter(Processor.setter(Builder::configuration)).constructor(ProcessorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<Integer> EXECUTION_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExecutionOrder").getter(Processor.getter(Processor::executionOrder)).setter(Processor.setter(Builder::executionOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionOrder").build()}).build();
    private static final SdkField<String> FALLBACK_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FallbackAction").getter(Processor.getter(Processor::fallbackActionAsString)).setter(Processor.setter(Builder::fallbackAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FallbackAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIGURATION_FIELD, EXECUTION_ORDER_FIELD, FALLBACK_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ProcessorConfiguration configuration;
    private final Integer executionOrder;
    private final String fallbackAction;

    private Processor(BuilderImpl builder) {
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.executionOrder = builder.executionOrder;
        this.fallbackAction = builder.fallbackAction;
    }

    public final String name() {
        return this.name;
    }

    public final ProcessorConfiguration configuration() {
        return this.configuration;
    }

    public final Integer executionOrder() {
        return this.executionOrder;
    }

    public final FallbackAction fallbackAction() {
        return FallbackAction.fromValue(this.fallbackAction);
    }

    public final String fallbackActionAsString() {
        return this.fallbackAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.fallbackActionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Processor)) {
            return false;
        }
        Processor other = (Processor)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.executionOrder(), other.executionOrder()) && Objects.equals(this.fallbackActionAsString(), other.fallbackActionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Processor").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Configuration", (Object)this.configuration()).add("ExecutionOrder", (Object)this.executionOrder()).add("FallbackAction", (Object)this.fallbackActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "ExecutionOrder": {
                return Optional.ofNullable(clazz.cast(this.executionOrder()));
            }
            case "FallbackAction": {
                return Optional.ofNullable(clazz.cast(this.fallbackActionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Processor, T> g) {
        return obj -> g.apply((Processor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ProcessorConfiguration configuration;
        private Integer executionOrder;
        private String fallbackAction;

        private BuilderImpl() {
        }

        private BuilderImpl(Processor model) {
            this.name(model.name);
            this.configuration(model.configuration);
            this.executionOrder(model.executionOrder);
            this.fallbackAction(model.fallbackAction);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ProcessorConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ProcessorConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(ProcessorConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Integer getExecutionOrder() {
            return this.executionOrder;
        }

        public final void setExecutionOrder(Integer executionOrder) {
            this.executionOrder = executionOrder;
        }

        @Override
        @Transient
        public final Builder executionOrder(Integer executionOrder) {
            this.executionOrder = executionOrder;
            return this;
        }

        public final String getFallbackAction() {
            return this.fallbackAction;
        }

        public final void setFallbackAction(String fallbackAction) {
            this.fallbackAction = fallbackAction;
        }

        @Override
        @Transient
        public final Builder fallbackAction(String fallbackAction) {
            this.fallbackAction = fallbackAction;
            return this;
        }

        @Override
        @Transient
        public final Builder fallbackAction(FallbackAction fallbackAction) {
            this.fallbackAction(fallbackAction == null ? null : fallbackAction.toString());
            return this;
        }

        public Processor build() {
            return new Processor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Processor> {
        public Builder name(String var1);

        public Builder configuration(ProcessorConfiguration var1);

        default public Builder configuration(Consumer<ProcessorConfiguration.Builder> configuration) {
            return this.configuration((ProcessorConfiguration)((ProcessorConfiguration.Builder)ProcessorConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder executionOrder(Integer var1);

        public Builder fallbackAction(String var1);

        public Builder fallbackAction(FallbackAction var1);
    }
}

