/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendChannelMessageResponse
extends ChimeSdkMessagingResponse
implements ToCopyableBuilder<Builder, SendChannelMessageResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(SendChannelMessageResponse.getter(SendChannelMessageResponse::channelArn)).setter(SendChannelMessageResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(SendChannelMessageResponse.getter(SendChannelMessageResponse::messageId)).setter(SendChannelMessageResponse.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<ChannelMessageStatusStructure> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(SendChannelMessageResponse.getter(SendChannelMessageResponse::status)).setter(SendChannelMessageResponse.setter(Builder::status)).constructor(ChannelMessageStatusStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, MESSAGE_ID_FIELD, STATUS_FIELD));
    private final String channelArn;
    private final String messageId;
    private final ChannelMessageStatusStructure status;

    private SendChannelMessageResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.messageId = builder.messageId;
        this.status = builder.status;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final ChannelMessageStatusStructure status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendChannelMessageResponse)) {
            return false;
        }
        SendChannelMessageResponse other = (SendChannelMessageResponse)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"SendChannelMessageResponse").add("ChannelArn", (Object)this.channelArn()).add("MessageId", (Object)this.messageId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendChannelMessageResponse, T> g) {
        return obj -> g.apply((SendChannelMessageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingResponse.BuilderImpl
    implements Builder {
        private String channelArn;
        private String messageId;
        private ChannelMessageStatusStructure status;

        private BuilderImpl() {
        }

        private BuilderImpl(SendChannelMessageResponse model) {
            super(model);
            this.channelArn(model.channelArn);
            this.messageId(model.messageId);
            this.status(model.status);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final ChannelMessageStatusStructure.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ChannelMessageStatusStructure.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ChannelMessageStatusStructure status) {
            this.status = status;
            return this;
        }

        @Override
        public SendChannelMessageResponse build() {
            return new SendChannelMessageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendChannelMessageResponse> {
        public Builder channelArn(String var1);

        public Builder messageId(String var1);

        public Builder status(ChannelMessageStatusStructure var1);

        default public Builder status(Consumer<ChannelMessageStatusStructure.Builder> status) {
            return this.status((ChannelMessageStatusStructure)((ChannelMessageStatusStructure.Builder)ChannelMessageStatusStructure.builder().applyMutation(status)).build());
        }
    }
}

