/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMeetingConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSinkType;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSourceType;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.SseAwsKeyManagementParams;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMediaCapturePipelineRequest
extends ChimeSdkMediaPipelinesRequest
implements ToCopyableBuilder<Builder, CreateMediaCapturePipelineRequest> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::sourceTypeAsString)).setter(CreateMediaCapturePipelineRequest.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::sourceArn)).setter(CreateMediaCapturePipelineRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> SINK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkType").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::sinkTypeAsString)).setter(CreateMediaCapturePipelineRequest.setter(Builder::sinkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkType").build()}).build();
    private static final SdkField<String> SINK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkArn").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::sinkArn)).setter(CreateMediaCapturePipelineRequest.setter(Builder::sinkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::clientRequestToken)).setter(CreateMediaCapturePipelineRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ChimeSdkMeetingConfiguration> CHIME_SDK_MEETING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChimeSdkMeetingConfiguration").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::chimeSdkMeetingConfiguration)).setter(CreateMediaCapturePipelineRequest.setter(Builder::chimeSdkMeetingConfiguration)).constructor(ChimeSdkMeetingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChimeSdkMeetingConfiguration").build()}).build();
    private static final SdkField<SseAwsKeyManagementParams> SSE_AWS_KEY_MANAGEMENT_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SseAwsKeyManagementParams").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::sseAwsKeyManagementParams)).setter(CreateMediaCapturePipelineRequest.setter(Builder::sseAwsKeyManagementParams)).constructor(SseAwsKeyManagementParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseAwsKeyManagementParams").build()}).build();
    private static final SdkField<String> SINK_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkIamRoleArn").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::sinkIamRoleArn)).setter(CreateMediaCapturePipelineRequest.setter(Builder::sinkIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkIamRoleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::tags)).setter(CreateMediaCapturePipelineRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, SOURCE_ARN_FIELD, SINK_TYPE_FIELD, SINK_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, CHIME_SDK_MEETING_CONFIGURATION_FIELD, SSE_AWS_KEY_MANAGEMENT_PARAMS_FIELD, SINK_IAM_ROLE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMediaCapturePipelineRequest.memberNameToFieldInitializer();
    private final String sourceType;
    private final String sourceArn;
    private final String sinkType;
    private final String sinkArn;
    private final String clientRequestToken;
    private final ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration;
    private final SseAwsKeyManagementParams sseAwsKeyManagementParams;
    private final String sinkIamRoleArn;
    private final List<Tag> tags;

    private CreateMediaCapturePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.sourceType = builder.sourceType;
        this.sourceArn = builder.sourceArn;
        this.sinkType = builder.sinkType;
        this.sinkArn = builder.sinkArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.chimeSdkMeetingConfiguration = builder.chimeSdkMeetingConfiguration;
        this.sseAwsKeyManagementParams = builder.sseAwsKeyManagementParams;
        this.sinkIamRoleArn = builder.sinkIamRoleArn;
        this.tags = builder.tags;
    }

    public final MediaPipelineSourceType sourceType() {
        return MediaPipelineSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final MediaPipelineSinkType sinkType() {
        return MediaPipelineSinkType.fromValue(this.sinkType);
    }

    public final String sinkTypeAsString() {
        return this.sinkType;
    }

    public final String sinkArn() {
        return this.sinkArn;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration() {
        return this.chimeSdkMeetingConfiguration;
    }

    public final SseAwsKeyManagementParams sseAwsKeyManagementParams() {
        return this.sseAwsKeyManagementParams;
    }

    public final String sinkIamRoleArn() {
        return this.sinkIamRoleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.chimeSdkMeetingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseAwsKeyManagementParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaCapturePipelineRequest)) {
            return false;
        }
        CreateMediaCapturePipelineRequest other = (CreateMediaCapturePipelineRequest)((Object)obj);
        return Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.sinkTypeAsString(), other.sinkTypeAsString()) && Objects.equals(this.sinkArn(), other.sinkArn()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.chimeSdkMeetingConfiguration(), other.chimeSdkMeetingConfiguration()) && Objects.equals(this.sseAwsKeyManagementParams(), other.sseAwsKeyManagementParams()) && Objects.equals(this.sinkIamRoleArn(), other.sinkIamRoleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMediaCapturePipelineRequest").add("SourceType", (Object)this.sourceTypeAsString()).add("SourceArn", (Object)(this.sourceArn() == null ? null : "*** Sensitive Data Redacted ***")).add("SinkType", (Object)this.sinkTypeAsString()).add("SinkArn", (Object)(this.sinkArn() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ChimeSdkMeetingConfiguration", (Object)this.chimeSdkMeetingConfiguration()).add("SseAwsKeyManagementParams", (Object)this.sseAwsKeyManagementParams()).add("SinkIamRoleArn", (Object)(this.sinkIamRoleArn() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "SinkType": {
                return Optional.ofNullable(clazz.cast(this.sinkTypeAsString()));
            }
            case "SinkArn": {
                return Optional.ofNullable(clazz.cast(this.sinkArn()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "ChimeSdkMeetingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chimeSdkMeetingConfiguration()));
            }
            case "SseAwsKeyManagementParams": {
                return Optional.ofNullable(clazz.cast(this.sseAwsKeyManagementParams()));
            }
            case "SinkIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.sinkIamRoleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("SinkType", SINK_TYPE_FIELD);
        map.put("SinkArn", SINK_ARN_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("ChimeSdkMeetingConfiguration", CHIME_SDK_MEETING_CONFIGURATION_FIELD);
        map.put("SseAwsKeyManagementParams", SSE_AWS_KEY_MANAGEMENT_PARAMS_FIELD);
        map.put("SinkIamRoleArn", SINK_IAM_ROLE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaCapturePipelineRequest, T> g) {
        return obj -> g.apply((CreateMediaCapturePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMediaPipelinesRequest.BuilderImpl
    implements Builder {
        private String sourceType;
        private String sourceArn;
        private String sinkType;
        private String sinkArn;
        private String clientRequestToken;
        private ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration;
        private SseAwsKeyManagementParams sseAwsKeyManagementParams;
        private String sinkIamRoleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaCapturePipelineRequest model) {
            super(model);
            this.sourceType(model.sourceType);
            this.sourceArn(model.sourceArn);
            this.sinkType(model.sinkType);
            this.sinkArn(model.sinkArn);
            this.clientRequestToken(model.clientRequestToken);
            this.chimeSdkMeetingConfiguration(model.chimeSdkMeetingConfiguration);
            this.sseAwsKeyManagementParams(model.sseAwsKeyManagementParams);
            this.sinkIamRoleArn(model.sinkIamRoleArn);
            this.tags(model.tags);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(MediaPipelineSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getSinkType() {
            return this.sinkType;
        }

        public final void setSinkType(String sinkType) {
            this.sinkType = sinkType;
        }

        @Override
        public final Builder sinkType(String sinkType) {
            this.sinkType = sinkType;
            return this;
        }

        @Override
        public final Builder sinkType(MediaPipelineSinkType sinkType) {
            this.sinkType(sinkType == null ? null : sinkType.toString());
            return this;
        }

        public final String getSinkArn() {
            return this.sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final ChimeSdkMeetingConfiguration.Builder getChimeSdkMeetingConfiguration() {
            return this.chimeSdkMeetingConfiguration != null ? this.chimeSdkMeetingConfiguration.toBuilder() : null;
        }

        public final void setChimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration.BuilderImpl chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration != null ? chimeSdkMeetingConfiguration.build() : null;
        }

        @Override
        public final Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration;
            return this;
        }

        public final SseAwsKeyManagementParams.Builder getSseAwsKeyManagementParams() {
            return this.sseAwsKeyManagementParams != null ? this.sseAwsKeyManagementParams.toBuilder() : null;
        }

        public final void setSseAwsKeyManagementParams(SseAwsKeyManagementParams.BuilderImpl sseAwsKeyManagementParams) {
            this.sseAwsKeyManagementParams = sseAwsKeyManagementParams != null ? sseAwsKeyManagementParams.build() : null;
        }

        @Override
        public final Builder sseAwsKeyManagementParams(SseAwsKeyManagementParams sseAwsKeyManagementParams) {
            this.sseAwsKeyManagementParams = sseAwsKeyManagementParams;
            return this;
        }

        public final String getSinkIamRoleArn() {
            return this.sinkIamRoleArn;
        }

        public final void setSinkIamRoleArn(String sinkIamRoleArn) {
            this.sinkIamRoleArn = sinkIamRoleArn;
        }

        @Override
        public final Builder sinkIamRoleArn(String sinkIamRoleArn) {
            this.sinkIamRoleArn = sinkIamRoleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMediaCapturePipelineRequest build() {
            return new CreateMediaCapturePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMediaPipelinesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMediaCapturePipelineRequest> {
        public Builder sourceType(String var1);

        public Builder sourceType(MediaPipelineSourceType var1);

        public Builder sourceArn(String var1);

        public Builder sinkType(String var1);

        public Builder sinkType(MediaPipelineSinkType var1);

        public Builder sinkArn(String var1);

        public Builder clientRequestToken(String var1);

        public Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration var1);

        default public Builder chimeSdkMeetingConfiguration(Consumer<ChimeSdkMeetingConfiguration.Builder> chimeSdkMeetingConfiguration) {
            return this.chimeSdkMeetingConfiguration((ChimeSdkMeetingConfiguration)((ChimeSdkMeetingConfiguration.Builder)ChimeSdkMeetingConfiguration.builder().applyMutation(chimeSdkMeetingConfiguration)).build());
        }

        public Builder sseAwsKeyManagementParams(SseAwsKeyManagementParams var1);

        default public Builder sseAwsKeyManagementParams(Consumer<SseAwsKeyManagementParams.Builder> sseAwsKeyManagementParams) {
            return this.sseAwsKeyManagementParams((SseAwsKeyManagementParams)((SseAwsKeyManagementParams.Builder)SseAwsKeyManagementParams.builder().applyMutation(sseAwsKeyManagementParams)).build());
        }

        public Builder sinkIamRoleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

