/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaCapturePipeline;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaConcatenationPipeline;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipeline;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaLiveConnectorPipeline;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamPipeline;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaPipeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaPipeline> {
    private static final SdkField<MediaCapturePipeline> MEDIA_CAPTURE_PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaCapturePipeline").getter(MediaPipeline.getter(MediaPipeline::mediaCapturePipeline)).setter(MediaPipeline.setter(Builder::mediaCapturePipeline)).constructor(MediaCapturePipeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaCapturePipeline").build()}).build();
    private static final SdkField<MediaLiveConnectorPipeline> MEDIA_LIVE_CONNECTOR_PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaLiveConnectorPipeline").getter(MediaPipeline.getter(MediaPipeline::mediaLiveConnectorPipeline)).setter(MediaPipeline.setter(Builder::mediaLiveConnectorPipeline)).constructor(MediaLiveConnectorPipeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaLiveConnectorPipeline").build()}).build();
    private static final SdkField<MediaConcatenationPipeline> MEDIA_CONCATENATION_PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaConcatenationPipeline").getter(MediaPipeline.getter(MediaPipeline::mediaConcatenationPipeline)).setter(MediaPipeline.setter(Builder::mediaConcatenationPipeline)).constructor(MediaConcatenationPipeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaConcatenationPipeline").build()}).build();
    private static final SdkField<MediaInsightsPipeline> MEDIA_INSIGHTS_PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaInsightsPipeline").getter(MediaPipeline.getter(MediaPipeline::mediaInsightsPipeline)).setter(MediaPipeline.setter(Builder::mediaInsightsPipeline)).constructor(MediaInsightsPipeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsPipeline").build()}).build();
    private static final SdkField<MediaStreamPipeline> MEDIA_STREAM_PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaStreamPipeline").getter(MediaPipeline.getter(MediaPipeline::mediaStreamPipeline)).setter(MediaPipeline.setter(Builder::mediaStreamPipeline)).constructor(MediaStreamPipeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaStreamPipeline").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_CAPTURE_PIPELINE_FIELD, MEDIA_LIVE_CONNECTOR_PIPELINE_FIELD, MEDIA_CONCATENATION_PIPELINE_FIELD, MEDIA_INSIGHTS_PIPELINE_FIELD, MEDIA_STREAM_PIPELINE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MediaCapturePipeline", MEDIA_CAPTURE_PIPELINE_FIELD);
            this.put("MediaLiveConnectorPipeline", MEDIA_LIVE_CONNECTOR_PIPELINE_FIELD);
            this.put("MediaConcatenationPipeline", MEDIA_CONCATENATION_PIPELINE_FIELD);
            this.put("MediaInsightsPipeline", MEDIA_INSIGHTS_PIPELINE_FIELD);
            this.put("MediaStreamPipeline", MEDIA_STREAM_PIPELINE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final MediaCapturePipeline mediaCapturePipeline;
    private final MediaLiveConnectorPipeline mediaLiveConnectorPipeline;
    private final MediaConcatenationPipeline mediaConcatenationPipeline;
    private final MediaInsightsPipeline mediaInsightsPipeline;
    private final MediaStreamPipeline mediaStreamPipeline;

    private MediaPipeline(BuilderImpl builder) {
        this.mediaCapturePipeline = builder.mediaCapturePipeline;
        this.mediaLiveConnectorPipeline = builder.mediaLiveConnectorPipeline;
        this.mediaConcatenationPipeline = builder.mediaConcatenationPipeline;
        this.mediaInsightsPipeline = builder.mediaInsightsPipeline;
        this.mediaStreamPipeline = builder.mediaStreamPipeline;
    }

    public final MediaCapturePipeline mediaCapturePipeline() {
        return this.mediaCapturePipeline;
    }

    public final MediaLiveConnectorPipeline mediaLiveConnectorPipeline() {
        return this.mediaLiveConnectorPipeline;
    }

    public final MediaConcatenationPipeline mediaConcatenationPipeline() {
        return this.mediaConcatenationPipeline;
    }

    public final MediaInsightsPipeline mediaInsightsPipeline() {
        return this.mediaInsightsPipeline;
    }

    public final MediaStreamPipeline mediaStreamPipeline() {
        return this.mediaStreamPipeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaCapturePipeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaLiveConnectorPipeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaConcatenationPipeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaInsightsPipeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamPipeline());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaPipeline)) {
            return false;
        }
        MediaPipeline other = (MediaPipeline)obj;
        return Objects.equals(this.mediaCapturePipeline(), other.mediaCapturePipeline()) && Objects.equals(this.mediaLiveConnectorPipeline(), other.mediaLiveConnectorPipeline()) && Objects.equals(this.mediaConcatenationPipeline(), other.mediaConcatenationPipeline()) && Objects.equals(this.mediaInsightsPipeline(), other.mediaInsightsPipeline()) && Objects.equals(this.mediaStreamPipeline(), other.mediaStreamPipeline());
    }

    public final String toString() {
        return ToString.builder((String)"MediaPipeline").add("MediaCapturePipeline", (Object)this.mediaCapturePipeline()).add("MediaLiveConnectorPipeline", (Object)this.mediaLiveConnectorPipeline()).add("MediaConcatenationPipeline", (Object)this.mediaConcatenationPipeline()).add("MediaInsightsPipeline", (Object)this.mediaInsightsPipeline()).add("MediaStreamPipeline", (Object)this.mediaStreamPipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaCapturePipeline": {
                return Optional.ofNullable(clazz.cast(this.mediaCapturePipeline()));
            }
            case "MediaLiveConnectorPipeline": {
                return Optional.ofNullable(clazz.cast(this.mediaLiveConnectorPipeline()));
            }
            case "MediaConcatenationPipeline": {
                return Optional.ofNullable(clazz.cast(this.mediaConcatenationPipeline()));
            }
            case "MediaInsightsPipeline": {
                return Optional.ofNullable(clazz.cast(this.mediaInsightsPipeline()));
            }
            case "MediaStreamPipeline": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamPipeline()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MediaPipeline, T> g) {
        return obj -> g.apply((MediaPipeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MediaCapturePipeline mediaCapturePipeline;
        private MediaLiveConnectorPipeline mediaLiveConnectorPipeline;
        private MediaConcatenationPipeline mediaConcatenationPipeline;
        private MediaInsightsPipeline mediaInsightsPipeline;
        private MediaStreamPipeline mediaStreamPipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaPipeline model) {
            this.mediaCapturePipeline(model.mediaCapturePipeline);
            this.mediaLiveConnectorPipeline(model.mediaLiveConnectorPipeline);
            this.mediaConcatenationPipeline(model.mediaConcatenationPipeline);
            this.mediaInsightsPipeline(model.mediaInsightsPipeline);
            this.mediaStreamPipeline(model.mediaStreamPipeline);
        }

        public final MediaCapturePipeline.Builder getMediaCapturePipeline() {
            return this.mediaCapturePipeline != null ? this.mediaCapturePipeline.toBuilder() : null;
        }

        public final void setMediaCapturePipeline(MediaCapturePipeline.BuilderImpl mediaCapturePipeline) {
            this.mediaCapturePipeline = mediaCapturePipeline != null ? mediaCapturePipeline.build() : null;
        }

        @Override
        public final Builder mediaCapturePipeline(MediaCapturePipeline mediaCapturePipeline) {
            this.mediaCapturePipeline = mediaCapturePipeline;
            return this;
        }

        public final MediaLiveConnectorPipeline.Builder getMediaLiveConnectorPipeline() {
            return this.mediaLiveConnectorPipeline != null ? this.mediaLiveConnectorPipeline.toBuilder() : null;
        }

        public final void setMediaLiveConnectorPipeline(MediaLiveConnectorPipeline.BuilderImpl mediaLiveConnectorPipeline) {
            this.mediaLiveConnectorPipeline = mediaLiveConnectorPipeline != null ? mediaLiveConnectorPipeline.build() : null;
        }

        @Override
        public final Builder mediaLiveConnectorPipeline(MediaLiveConnectorPipeline mediaLiveConnectorPipeline) {
            this.mediaLiveConnectorPipeline = mediaLiveConnectorPipeline;
            return this;
        }

        public final MediaConcatenationPipeline.Builder getMediaConcatenationPipeline() {
            return this.mediaConcatenationPipeline != null ? this.mediaConcatenationPipeline.toBuilder() : null;
        }

        public final void setMediaConcatenationPipeline(MediaConcatenationPipeline.BuilderImpl mediaConcatenationPipeline) {
            this.mediaConcatenationPipeline = mediaConcatenationPipeline != null ? mediaConcatenationPipeline.build() : null;
        }

        @Override
        public final Builder mediaConcatenationPipeline(MediaConcatenationPipeline mediaConcatenationPipeline) {
            this.mediaConcatenationPipeline = mediaConcatenationPipeline;
            return this;
        }

        public final MediaInsightsPipeline.Builder getMediaInsightsPipeline() {
            return this.mediaInsightsPipeline != null ? this.mediaInsightsPipeline.toBuilder() : null;
        }

        public final void setMediaInsightsPipeline(MediaInsightsPipeline.BuilderImpl mediaInsightsPipeline) {
            this.mediaInsightsPipeline = mediaInsightsPipeline != null ? mediaInsightsPipeline.build() : null;
        }

        @Override
        public final Builder mediaInsightsPipeline(MediaInsightsPipeline mediaInsightsPipeline) {
            this.mediaInsightsPipeline = mediaInsightsPipeline;
            return this;
        }

        public final MediaStreamPipeline.Builder getMediaStreamPipeline() {
            return this.mediaStreamPipeline != null ? this.mediaStreamPipeline.toBuilder() : null;
        }

        public final void setMediaStreamPipeline(MediaStreamPipeline.BuilderImpl mediaStreamPipeline) {
            this.mediaStreamPipeline = mediaStreamPipeline != null ? mediaStreamPipeline.build() : null;
        }

        @Override
        public final Builder mediaStreamPipeline(MediaStreamPipeline mediaStreamPipeline) {
            this.mediaStreamPipeline = mediaStreamPipeline;
            return this;
        }

        public MediaPipeline build() {
            return new MediaPipeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaPipeline> {
        public Builder mediaCapturePipeline(MediaCapturePipeline var1);

        default public Builder mediaCapturePipeline(Consumer<MediaCapturePipeline.Builder> mediaCapturePipeline) {
            return this.mediaCapturePipeline((MediaCapturePipeline)((MediaCapturePipeline.Builder)MediaCapturePipeline.builder().applyMutation(mediaCapturePipeline)).build());
        }

        public Builder mediaLiveConnectorPipeline(MediaLiveConnectorPipeline var1);

        default public Builder mediaLiveConnectorPipeline(Consumer<MediaLiveConnectorPipeline.Builder> mediaLiveConnectorPipeline) {
            return this.mediaLiveConnectorPipeline((MediaLiveConnectorPipeline)((MediaLiveConnectorPipeline.Builder)MediaLiveConnectorPipeline.builder().applyMutation(mediaLiveConnectorPipeline)).build());
        }

        public Builder mediaConcatenationPipeline(MediaConcatenationPipeline var1);

        default public Builder mediaConcatenationPipeline(Consumer<MediaConcatenationPipeline.Builder> mediaConcatenationPipeline) {
            return this.mediaConcatenationPipeline((MediaConcatenationPipeline)((MediaConcatenationPipeline.Builder)MediaConcatenationPipeline.builder().applyMutation(mediaConcatenationPipeline)).build());
        }

        public Builder mediaInsightsPipeline(MediaInsightsPipeline var1);

        default public Builder mediaInsightsPipeline(Consumer<MediaInsightsPipeline.Builder> mediaInsightsPipeline) {
            return this.mediaInsightsPipeline((MediaInsightsPipeline)((MediaInsightsPipeline.Builder)MediaInsightsPipeline.builder().applyMutation(mediaInsightsPipeline)).build());
        }

        public Builder mediaStreamPipeline(MediaStreamPipeline var1);

        default public Builder mediaStreamPipeline(Consumer<MediaStreamPipeline.Builder> mediaStreamPipeline) {
            return this.mediaStreamPipeline((MediaStreamPipeline)((MediaStreamPipeline.Builder)MediaStreamPipeline.builder().applyMutation(mediaStreamPipeline)).build());
        }
    }
}

