/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSpeakerSearchTaskRequest
extends ChimeSdkMediaPipelinesRequest
implements ToCopyableBuilder<Builder, StartSpeakerSearchTaskRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(StartSpeakerSearchTaskRequest.getter(StartSpeakerSearchTaskRequest::identifier)).setter(StartSpeakerSearchTaskRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> VOICE_PROFILE_DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceProfileDomainArn").getter(StartSpeakerSearchTaskRequest.getter(StartSpeakerSearchTaskRequest::voiceProfileDomainArn)).setter(StartSpeakerSearchTaskRequest.setter(Builder::voiceProfileDomainArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileDomainArn").build()}).build();
    private static final SdkField<KinesisVideoStreamSourceTaskConfiguration> KINESIS_VIDEO_STREAM_SOURCE_TASK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisVideoStreamSourceTaskConfiguration").getter(StartSpeakerSearchTaskRequest.getter(StartSpeakerSearchTaskRequest::kinesisVideoStreamSourceTaskConfiguration)).setter(StartSpeakerSearchTaskRequest.setter(Builder::kinesisVideoStreamSourceTaskConfiguration)).constructor(KinesisVideoStreamSourceTaskConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisVideoStreamSourceTaskConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartSpeakerSearchTaskRequest.getter(StartSpeakerSearchTaskRequest::clientRequestToken)).setter(StartSpeakerSearchTaskRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, VOICE_PROFILE_DOMAIN_ARN_FIELD, KINESIS_VIDEO_STREAM_SOURCE_TASK_CONFIGURATION_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String identifier;
    private final String voiceProfileDomainArn;
    private final KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration;
    private final String clientRequestToken;

    private StartSpeakerSearchTaskRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.voiceProfileDomainArn = builder.voiceProfileDomainArn;
        this.kinesisVideoStreamSourceTaskConfiguration = builder.kinesisVideoStreamSourceTaskConfiguration;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String voiceProfileDomainArn() {
        return this.voiceProfileDomainArn;
    }

    public final KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration() {
        return this.kinesisVideoStreamSourceTaskConfiguration;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceProfileDomainArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisVideoStreamSourceTaskConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSpeakerSearchTaskRequest)) {
            return false;
        }
        StartSpeakerSearchTaskRequest other = (StartSpeakerSearchTaskRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.voiceProfileDomainArn(), other.voiceProfileDomainArn()) && Objects.equals(this.kinesisVideoStreamSourceTaskConfiguration(), other.kinesisVideoStreamSourceTaskConfiguration()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartSpeakerSearchTaskRequest").add("Identifier", (Object)this.identifier()).add("VoiceProfileDomainArn", (Object)(this.voiceProfileDomainArn() == null ? null : "*** Sensitive Data Redacted ***")).add("KinesisVideoStreamSourceTaskConfiguration", (Object)this.kinesisVideoStreamSourceTaskConfiguration()).add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "VoiceProfileDomainArn": {
                return Optional.ofNullable(clazz.cast(this.voiceProfileDomainArn()));
            }
            case "KinesisVideoStreamSourceTaskConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kinesisVideoStreamSourceTaskConfiguration()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSpeakerSearchTaskRequest, T> g) {
        return obj -> g.apply((StartSpeakerSearchTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMediaPipelinesRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String voiceProfileDomainArn;
        private KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSpeakerSearchTaskRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.voiceProfileDomainArn(model.voiceProfileDomainArn);
            this.kinesisVideoStreamSourceTaskConfiguration(model.kinesisVideoStreamSourceTaskConfiguration);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getVoiceProfileDomainArn() {
            return this.voiceProfileDomainArn;
        }

        public final void setVoiceProfileDomainArn(String voiceProfileDomainArn) {
            this.voiceProfileDomainArn = voiceProfileDomainArn;
        }

        @Override
        public final Builder voiceProfileDomainArn(String voiceProfileDomainArn) {
            this.voiceProfileDomainArn = voiceProfileDomainArn;
            return this;
        }

        public final KinesisVideoStreamSourceTaskConfiguration.Builder getKinesisVideoStreamSourceTaskConfiguration() {
            return this.kinesisVideoStreamSourceTaskConfiguration != null ? this.kinesisVideoStreamSourceTaskConfiguration.toBuilder() : null;
        }

        public final void setKinesisVideoStreamSourceTaskConfiguration(KinesisVideoStreamSourceTaskConfiguration.BuilderImpl kinesisVideoStreamSourceTaskConfiguration) {
            this.kinesisVideoStreamSourceTaskConfiguration = kinesisVideoStreamSourceTaskConfiguration != null ? kinesisVideoStreamSourceTaskConfiguration.build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamSourceTaskConfiguration(KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration) {
            this.kinesisVideoStreamSourceTaskConfiguration = kinesisVideoStreamSourceTaskConfiguration;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSpeakerSearchTaskRequest build() {
            return new StartSpeakerSearchTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMediaPipelinesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSpeakerSearchTaskRequest> {
        public Builder identifier(String var1);

        public Builder voiceProfileDomainArn(String var1);

        public Builder kinesisVideoStreamSourceTaskConfiguration(KinesisVideoStreamSourceTaskConfiguration var1);

        default public Builder kinesisVideoStreamSourceTaskConfiguration(Consumer<KinesisVideoStreamSourceTaskConfiguration.Builder> kinesisVideoStreamSourceTaskConfiguration) {
            return this.kinesisVideoStreamSourceTaskConfiguration((KinesisVideoStreamSourceTaskConfiguration)((KinesisVideoStreamSourceTaskConfiguration.Builder)KinesisVideoStreamSourceTaskConfiguration.builder().applyMutation(kinesisVideoStreamSourceTaskConfiguration)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

