/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisVideoStreamPoolSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisVideoStreamPoolSummary> {
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolName").getter(KinesisVideoStreamPoolSummary.getter(KinesisVideoStreamPoolSummary::poolName)).setter(KinesisVideoStreamPoolSummary.setter(Builder::poolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(KinesisVideoStreamPoolSummary.getter(KinesisVideoStreamPoolSummary::poolId)).setter(KinesisVideoStreamPoolSummary.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolArn").getter(KinesisVideoStreamPoolSummary.getter(KinesisVideoStreamPoolSummary::poolArn)).setter(KinesisVideoStreamPoolSummary.setter(Builder::poolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_NAME_FIELD, POOL_ID_FIELD, POOL_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String poolName;
    private final String poolId;
    private final String poolArn;

    private KinesisVideoStreamPoolSummary(BuilderImpl builder) {
        this.poolName = builder.poolName;
        this.poolId = builder.poolId;
        this.poolArn = builder.poolArn;
    }

    public final String poolName() {
        return this.poolName;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final String poolArn() {
        return this.poolArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.poolName());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamPoolSummary)) {
            return false;
        }
        KinesisVideoStreamPoolSummary other = (KinesisVideoStreamPoolSummary)obj;
        return Objects.equals(this.poolName(), other.poolName()) && Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.poolArn(), other.poolArn());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisVideoStreamPoolSummary").add("PoolName", (Object)this.poolName()).add("PoolId", (Object)this.poolId()).add("PoolArn", (Object)(this.poolArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolName": {
                return Optional.ofNullable(clazz.cast(this.poolName()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "PoolArn": {
                return Optional.ofNullable(clazz.cast(this.poolArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamPoolSummary, T> g) {
        return obj -> g.apply((KinesisVideoStreamPoolSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String poolName;
        private String poolId;
        private String poolArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamPoolSummary model) {
            this.poolName(model.poolName);
            this.poolId(model.poolId);
            this.poolArn(model.poolArn);
        }

        public final String getPoolName() {
            return this.poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getPoolArn() {
            return this.poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public KinesisVideoStreamPoolSummary build() {
            return new KinesisVideoStreamPoolSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisVideoStreamPoolSummary> {
        public Builder poolName(String var1);

        public Builder poolId(String var1);

        public Builder poolArn(String var1);
    }
}

