/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MediaPipelineElementStatus {
    NOT_STARTED("NotStarted"),
    NOT_SUPPORTED("NotSupported"),
    INITIALIZING("Initializing"),
    IN_PROGRESS("InProgress"),
    FAILED("Failed"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    PAUSED("Paused"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MediaPipelineElementStatus> VALUE_MAP;
    private final String value;

    private MediaPipelineElementStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaPipelineElementStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaPipelineElementStatus> knownValues() {
        EnumSet<MediaPipelineElementStatus> knownValues = EnumSet.allOf(MediaPipelineElementStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MediaPipelineElementStatus.class, MediaPipelineElementStatus::toString);
    }
}

