/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElementType;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.SnsTopicSinkConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.SqsQueueSinkConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceEnhancementSinkConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaInsightsPipelineConfigurationElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaInsightsPipelineConfigurationElement> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(MediaInsightsPipelineConfigurationElement.getter(MediaInsightsPipelineConfigurationElement::typeAsString)).setter(MediaInsightsPipelineConfigurationElement.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<AmazonTranscribeCallAnalyticsProcessorConfiguration> AMAZON_TRANSCRIBE_CALL_ANALYTICS_PROCESSOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmazonTranscribeCallAnalyticsProcessorConfiguration").getter(MediaInsightsPipelineConfigurationElement.getter(MediaInsightsPipelineConfigurationElement::amazonTranscribeCallAnalyticsProcessorConfiguration)).setter(MediaInsightsPipelineConfigurationElement.setter(Builder::amazonTranscribeCallAnalyticsProcessorConfiguration)).constructor(AmazonTranscribeCallAnalyticsProcessorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonTranscribeCallAnalyticsProcessorConfiguration").build()}).build();
    private static final SdkField<AmazonTranscribeProcessorConfiguration> AMAZON_TRANSCRIBE_PROCESSOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmazonTranscribeProcessorConfiguration").getter(MediaInsightsPipelineConfigurationElement.getter(MediaInsightsPipelineConfigurationElement::amazonTranscribeProcessorConfiguration)).setter(MediaInsightsPipelineConfigurationElement.setter(Builder::amazonTranscribeProcessorConfiguration)).constructor(AmazonTranscribeProcessorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonTranscribeProcessorConfiguration").build()}).build();
    private static final SdkField<KinesisDataStreamSinkConfiguration> KINESIS_DATA_STREAM_SINK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisDataStreamSinkConfiguration").getter(MediaInsightsPipelineConfigurationElement.getter(MediaInsightsPipelineConfigurationElement::kinesisDataStreamSinkConfiguration)).setter(MediaInsightsPipelineConfigurationElement.setter(Builder::kinesisDataStreamSinkConfiguration)).constructor(KinesisDataStreamSinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisDataStreamSinkConfiguration").build()}).build();
    private static final SdkField<S3RecordingSinkConfiguration> S3_RECORDING_SINK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3RecordingSinkConfiguration").getter(MediaInsightsPipelineConfigurationElement.getter(MediaInsightsPipelineConfigurationElement::s3RecordingSinkConfiguration)).setter(MediaInsightsPipelineConfigurationElement.setter(Builder::s3RecordingSinkConfiguration)).constructor(S3RecordingSinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3RecordingSinkConfiguration").build()}).build();
    private static final SdkField<VoiceAnalyticsProcessorConfiguration> VOICE_ANALYTICS_PROCESSOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VoiceAnalyticsProcessorConfiguration").getter(MediaInsightsPipelineConfigurationElement.getter(MediaInsightsPipelineConfigurationElement::voiceAnalyticsProcessorConfiguration)).setter(MediaInsightsPipelineConfigurationElement.setter(Builder::voiceAnalyticsProcessorConfiguration)).constructor(VoiceAnalyticsProcessorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceAnalyticsProcessorConfiguration").build()}).build();
    private static final SdkField<LambdaFunctionSinkConfiguration> LAMBDA_FUNCTION_SINK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaFunctionSinkConfiguration").getter(MediaInsightsPipelineConfigurationElement.getter(MediaInsightsPipelineConfigurationElement::lambdaFunctionSinkConfiguration)).setter(MediaInsightsPipelineConfigurationElement.setter(Builder::lambdaFunctionSinkConfiguration)).constructor(LambdaFunctionSinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionSinkConfiguration").build()}).build();
    private static final SdkField<SqsQueueSinkConfiguration> SQS_QUEUE_SINK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SqsQueueSinkConfiguration").getter(MediaInsightsPipelineConfigurationElement.getter(MediaInsightsPipelineConfigurationElement::sqsQueueSinkConfiguration)).setter(MediaInsightsPipelineConfigurationElement.setter(Builder::sqsQueueSinkConfiguration)).constructor(SqsQueueSinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueSinkConfiguration").build()}).build();
    private static final SdkField<SnsTopicSinkConfiguration> SNS_TOPIC_SINK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnsTopicSinkConfiguration").getter(MediaInsightsPipelineConfigurationElement.getter(MediaInsightsPipelineConfigurationElement::snsTopicSinkConfiguration)).setter(MediaInsightsPipelineConfigurationElement.setter(Builder::snsTopicSinkConfiguration)).constructor(SnsTopicSinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicSinkConfiguration").build()}).build();
    private static final SdkField<VoiceEnhancementSinkConfiguration> VOICE_ENHANCEMENT_SINK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VoiceEnhancementSinkConfiguration").getter(MediaInsightsPipelineConfigurationElement.getter(MediaInsightsPipelineConfigurationElement::voiceEnhancementSinkConfiguration)).setter(MediaInsightsPipelineConfigurationElement.setter(Builder::voiceEnhancementSinkConfiguration)).constructor(VoiceEnhancementSinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceEnhancementSinkConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, AMAZON_TRANSCRIBE_CALL_ANALYTICS_PROCESSOR_CONFIGURATION_FIELD, AMAZON_TRANSCRIBE_PROCESSOR_CONFIGURATION_FIELD, KINESIS_DATA_STREAM_SINK_CONFIGURATION_FIELD, S3_RECORDING_SINK_CONFIGURATION_FIELD, VOICE_ANALYTICS_PROCESSOR_CONFIGURATION_FIELD, LAMBDA_FUNCTION_SINK_CONFIGURATION_FIELD, SQS_QUEUE_SINK_CONFIGURATION_FIELD, SNS_TOPIC_SINK_CONFIGURATION_FIELD, VOICE_ENHANCEMENT_SINK_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final AmazonTranscribeCallAnalyticsProcessorConfiguration amazonTranscribeCallAnalyticsProcessorConfiguration;
    private final AmazonTranscribeProcessorConfiguration amazonTranscribeProcessorConfiguration;
    private final KinesisDataStreamSinkConfiguration kinesisDataStreamSinkConfiguration;
    private final S3RecordingSinkConfiguration s3RecordingSinkConfiguration;
    private final VoiceAnalyticsProcessorConfiguration voiceAnalyticsProcessorConfiguration;
    private final LambdaFunctionSinkConfiguration lambdaFunctionSinkConfiguration;
    private final SqsQueueSinkConfiguration sqsQueueSinkConfiguration;
    private final SnsTopicSinkConfiguration snsTopicSinkConfiguration;
    private final VoiceEnhancementSinkConfiguration voiceEnhancementSinkConfiguration;

    private MediaInsightsPipelineConfigurationElement(BuilderImpl builder) {
        this.type = builder.type;
        this.amazonTranscribeCallAnalyticsProcessorConfiguration = builder.amazonTranscribeCallAnalyticsProcessorConfiguration;
        this.amazonTranscribeProcessorConfiguration = builder.amazonTranscribeProcessorConfiguration;
        this.kinesisDataStreamSinkConfiguration = builder.kinesisDataStreamSinkConfiguration;
        this.s3RecordingSinkConfiguration = builder.s3RecordingSinkConfiguration;
        this.voiceAnalyticsProcessorConfiguration = builder.voiceAnalyticsProcessorConfiguration;
        this.lambdaFunctionSinkConfiguration = builder.lambdaFunctionSinkConfiguration;
        this.sqsQueueSinkConfiguration = builder.sqsQueueSinkConfiguration;
        this.snsTopicSinkConfiguration = builder.snsTopicSinkConfiguration;
        this.voiceEnhancementSinkConfiguration = builder.voiceEnhancementSinkConfiguration;
    }

    public final MediaInsightsPipelineConfigurationElementType type() {
        return MediaInsightsPipelineConfigurationElementType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final AmazonTranscribeCallAnalyticsProcessorConfiguration amazonTranscribeCallAnalyticsProcessorConfiguration() {
        return this.amazonTranscribeCallAnalyticsProcessorConfiguration;
    }

    public final AmazonTranscribeProcessorConfiguration amazonTranscribeProcessorConfiguration() {
        return this.amazonTranscribeProcessorConfiguration;
    }

    public final KinesisDataStreamSinkConfiguration kinesisDataStreamSinkConfiguration() {
        return this.kinesisDataStreamSinkConfiguration;
    }

    public final S3RecordingSinkConfiguration s3RecordingSinkConfiguration() {
        return this.s3RecordingSinkConfiguration;
    }

    public final VoiceAnalyticsProcessorConfiguration voiceAnalyticsProcessorConfiguration() {
        return this.voiceAnalyticsProcessorConfiguration;
    }

    public final LambdaFunctionSinkConfiguration lambdaFunctionSinkConfiguration() {
        return this.lambdaFunctionSinkConfiguration;
    }

    public final SqsQueueSinkConfiguration sqsQueueSinkConfiguration() {
        return this.sqsQueueSinkConfiguration;
    }

    public final SnsTopicSinkConfiguration snsTopicSinkConfiguration() {
        return this.snsTopicSinkConfiguration;
    }

    public final VoiceEnhancementSinkConfiguration voiceEnhancementSinkConfiguration() {
        return this.voiceEnhancementSinkConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonTranscribeCallAnalyticsProcessorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonTranscribeProcessorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisDataStreamSinkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3RecordingSinkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceAnalyticsProcessorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionSinkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsQueueSinkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicSinkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceEnhancementSinkConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaInsightsPipelineConfigurationElement)) {
            return false;
        }
        MediaInsightsPipelineConfigurationElement other = (MediaInsightsPipelineConfigurationElement)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.amazonTranscribeCallAnalyticsProcessorConfiguration(), other.amazonTranscribeCallAnalyticsProcessorConfiguration()) && Objects.equals(this.amazonTranscribeProcessorConfiguration(), other.amazonTranscribeProcessorConfiguration()) && Objects.equals(this.kinesisDataStreamSinkConfiguration(), other.kinesisDataStreamSinkConfiguration()) && Objects.equals(this.s3RecordingSinkConfiguration(), other.s3RecordingSinkConfiguration()) && Objects.equals(this.voiceAnalyticsProcessorConfiguration(), other.voiceAnalyticsProcessorConfiguration()) && Objects.equals(this.lambdaFunctionSinkConfiguration(), other.lambdaFunctionSinkConfiguration()) && Objects.equals(this.sqsQueueSinkConfiguration(), other.sqsQueueSinkConfiguration()) && Objects.equals(this.snsTopicSinkConfiguration(), other.snsTopicSinkConfiguration()) && Objects.equals(this.voiceEnhancementSinkConfiguration(), other.voiceEnhancementSinkConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"MediaInsightsPipelineConfigurationElement").add("Type", (Object)this.typeAsString()).add("AmazonTranscribeCallAnalyticsProcessorConfiguration", (Object)this.amazonTranscribeCallAnalyticsProcessorConfiguration()).add("AmazonTranscribeProcessorConfiguration", (Object)this.amazonTranscribeProcessorConfiguration()).add("KinesisDataStreamSinkConfiguration", (Object)this.kinesisDataStreamSinkConfiguration()).add("S3RecordingSinkConfiguration", (Object)this.s3RecordingSinkConfiguration()).add("VoiceAnalyticsProcessorConfiguration", (Object)this.voiceAnalyticsProcessorConfiguration()).add("LambdaFunctionSinkConfiguration", (Object)this.lambdaFunctionSinkConfiguration()).add("SqsQueueSinkConfiguration", (Object)this.sqsQueueSinkConfiguration()).add("SnsTopicSinkConfiguration", (Object)this.snsTopicSinkConfiguration()).add("VoiceEnhancementSinkConfiguration", (Object)this.voiceEnhancementSinkConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "AmazonTranscribeCallAnalyticsProcessorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.amazonTranscribeCallAnalyticsProcessorConfiguration()));
            }
            case "AmazonTranscribeProcessorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.amazonTranscribeProcessorConfiguration()));
            }
            case "KinesisDataStreamSinkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kinesisDataStreamSinkConfiguration()));
            }
            case "S3RecordingSinkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3RecordingSinkConfiguration()));
            }
            case "VoiceAnalyticsProcessorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.voiceAnalyticsProcessorConfiguration()));
            }
            case "LambdaFunctionSinkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionSinkConfiguration()));
            }
            case "SqsQueueSinkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sqsQueueSinkConfiguration()));
            }
            case "SnsTopicSinkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snsTopicSinkConfiguration()));
            }
            case "VoiceEnhancementSinkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.voiceEnhancementSinkConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaInsightsPipelineConfigurationElement, T> g) {
        return obj -> g.apply((MediaInsightsPipelineConfigurationElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private AmazonTranscribeCallAnalyticsProcessorConfiguration amazonTranscribeCallAnalyticsProcessorConfiguration;
        private AmazonTranscribeProcessorConfiguration amazonTranscribeProcessorConfiguration;
        private KinesisDataStreamSinkConfiguration kinesisDataStreamSinkConfiguration;
        private S3RecordingSinkConfiguration s3RecordingSinkConfiguration;
        private VoiceAnalyticsProcessorConfiguration voiceAnalyticsProcessorConfiguration;
        private LambdaFunctionSinkConfiguration lambdaFunctionSinkConfiguration;
        private SqsQueueSinkConfiguration sqsQueueSinkConfiguration;
        private SnsTopicSinkConfiguration snsTopicSinkConfiguration;
        private VoiceEnhancementSinkConfiguration voiceEnhancementSinkConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaInsightsPipelineConfigurationElement model) {
            this.type(model.type);
            this.amazonTranscribeCallAnalyticsProcessorConfiguration(model.amazonTranscribeCallAnalyticsProcessorConfiguration);
            this.amazonTranscribeProcessorConfiguration(model.amazonTranscribeProcessorConfiguration);
            this.kinesisDataStreamSinkConfiguration(model.kinesisDataStreamSinkConfiguration);
            this.s3RecordingSinkConfiguration(model.s3RecordingSinkConfiguration);
            this.voiceAnalyticsProcessorConfiguration(model.voiceAnalyticsProcessorConfiguration);
            this.lambdaFunctionSinkConfiguration(model.lambdaFunctionSinkConfiguration);
            this.sqsQueueSinkConfiguration(model.sqsQueueSinkConfiguration);
            this.snsTopicSinkConfiguration(model.snsTopicSinkConfiguration);
            this.voiceEnhancementSinkConfiguration(model.voiceEnhancementSinkConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MediaInsightsPipelineConfigurationElementType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AmazonTranscribeCallAnalyticsProcessorConfiguration.Builder getAmazonTranscribeCallAnalyticsProcessorConfiguration() {
            return this.amazonTranscribeCallAnalyticsProcessorConfiguration != null ? this.amazonTranscribeCallAnalyticsProcessorConfiguration.toBuilder() : null;
        }

        public final void setAmazonTranscribeCallAnalyticsProcessorConfiguration(AmazonTranscribeCallAnalyticsProcessorConfiguration.BuilderImpl amazonTranscribeCallAnalyticsProcessorConfiguration) {
            this.amazonTranscribeCallAnalyticsProcessorConfiguration = amazonTranscribeCallAnalyticsProcessorConfiguration != null ? amazonTranscribeCallAnalyticsProcessorConfiguration.build() : null;
        }

        @Override
        public final Builder amazonTranscribeCallAnalyticsProcessorConfiguration(AmazonTranscribeCallAnalyticsProcessorConfiguration amazonTranscribeCallAnalyticsProcessorConfiguration) {
            this.amazonTranscribeCallAnalyticsProcessorConfiguration = amazonTranscribeCallAnalyticsProcessorConfiguration;
            return this;
        }

        public final AmazonTranscribeProcessorConfiguration.Builder getAmazonTranscribeProcessorConfiguration() {
            return this.amazonTranscribeProcessorConfiguration != null ? this.amazonTranscribeProcessorConfiguration.toBuilder() : null;
        }

        public final void setAmazonTranscribeProcessorConfiguration(AmazonTranscribeProcessorConfiguration.BuilderImpl amazonTranscribeProcessorConfiguration) {
            this.amazonTranscribeProcessorConfiguration = amazonTranscribeProcessorConfiguration != null ? amazonTranscribeProcessorConfiguration.build() : null;
        }

        @Override
        public final Builder amazonTranscribeProcessorConfiguration(AmazonTranscribeProcessorConfiguration amazonTranscribeProcessorConfiguration) {
            this.amazonTranscribeProcessorConfiguration = amazonTranscribeProcessorConfiguration;
            return this;
        }

        public final KinesisDataStreamSinkConfiguration.Builder getKinesisDataStreamSinkConfiguration() {
            return this.kinesisDataStreamSinkConfiguration != null ? this.kinesisDataStreamSinkConfiguration.toBuilder() : null;
        }

        public final void setKinesisDataStreamSinkConfiguration(KinesisDataStreamSinkConfiguration.BuilderImpl kinesisDataStreamSinkConfiguration) {
            this.kinesisDataStreamSinkConfiguration = kinesisDataStreamSinkConfiguration != null ? kinesisDataStreamSinkConfiguration.build() : null;
        }

        @Override
        public final Builder kinesisDataStreamSinkConfiguration(KinesisDataStreamSinkConfiguration kinesisDataStreamSinkConfiguration) {
            this.kinesisDataStreamSinkConfiguration = kinesisDataStreamSinkConfiguration;
            return this;
        }

        public final S3RecordingSinkConfiguration.Builder getS3RecordingSinkConfiguration() {
            return this.s3RecordingSinkConfiguration != null ? this.s3RecordingSinkConfiguration.toBuilder() : null;
        }

        public final void setS3RecordingSinkConfiguration(S3RecordingSinkConfiguration.BuilderImpl s3RecordingSinkConfiguration) {
            this.s3RecordingSinkConfiguration = s3RecordingSinkConfiguration != null ? s3RecordingSinkConfiguration.build() : null;
        }

        @Override
        public final Builder s3RecordingSinkConfiguration(S3RecordingSinkConfiguration s3RecordingSinkConfiguration) {
            this.s3RecordingSinkConfiguration = s3RecordingSinkConfiguration;
            return this;
        }

        public final VoiceAnalyticsProcessorConfiguration.Builder getVoiceAnalyticsProcessorConfiguration() {
            return this.voiceAnalyticsProcessorConfiguration != null ? this.voiceAnalyticsProcessorConfiguration.toBuilder() : null;
        }

        public final void setVoiceAnalyticsProcessorConfiguration(VoiceAnalyticsProcessorConfiguration.BuilderImpl voiceAnalyticsProcessorConfiguration) {
            this.voiceAnalyticsProcessorConfiguration = voiceAnalyticsProcessorConfiguration != null ? voiceAnalyticsProcessorConfiguration.build() : null;
        }

        @Override
        public final Builder voiceAnalyticsProcessorConfiguration(VoiceAnalyticsProcessorConfiguration voiceAnalyticsProcessorConfiguration) {
            this.voiceAnalyticsProcessorConfiguration = voiceAnalyticsProcessorConfiguration;
            return this;
        }

        public final LambdaFunctionSinkConfiguration.Builder getLambdaFunctionSinkConfiguration() {
            return this.lambdaFunctionSinkConfiguration != null ? this.lambdaFunctionSinkConfiguration.toBuilder() : null;
        }

        public final void setLambdaFunctionSinkConfiguration(LambdaFunctionSinkConfiguration.BuilderImpl lambdaFunctionSinkConfiguration) {
            this.lambdaFunctionSinkConfiguration = lambdaFunctionSinkConfiguration != null ? lambdaFunctionSinkConfiguration.build() : null;
        }

        @Override
        public final Builder lambdaFunctionSinkConfiguration(LambdaFunctionSinkConfiguration lambdaFunctionSinkConfiguration) {
            this.lambdaFunctionSinkConfiguration = lambdaFunctionSinkConfiguration;
            return this;
        }

        public final SqsQueueSinkConfiguration.Builder getSqsQueueSinkConfiguration() {
            return this.sqsQueueSinkConfiguration != null ? this.sqsQueueSinkConfiguration.toBuilder() : null;
        }

        public final void setSqsQueueSinkConfiguration(SqsQueueSinkConfiguration.BuilderImpl sqsQueueSinkConfiguration) {
            this.sqsQueueSinkConfiguration = sqsQueueSinkConfiguration != null ? sqsQueueSinkConfiguration.build() : null;
        }

        @Override
        public final Builder sqsQueueSinkConfiguration(SqsQueueSinkConfiguration sqsQueueSinkConfiguration) {
            this.sqsQueueSinkConfiguration = sqsQueueSinkConfiguration;
            return this;
        }

        public final SnsTopicSinkConfiguration.Builder getSnsTopicSinkConfiguration() {
            return this.snsTopicSinkConfiguration != null ? this.snsTopicSinkConfiguration.toBuilder() : null;
        }

        public final void setSnsTopicSinkConfiguration(SnsTopicSinkConfiguration.BuilderImpl snsTopicSinkConfiguration) {
            this.snsTopicSinkConfiguration = snsTopicSinkConfiguration != null ? snsTopicSinkConfiguration.build() : null;
        }

        @Override
        public final Builder snsTopicSinkConfiguration(SnsTopicSinkConfiguration snsTopicSinkConfiguration) {
            this.snsTopicSinkConfiguration = snsTopicSinkConfiguration;
            return this;
        }

        public final VoiceEnhancementSinkConfiguration.Builder getVoiceEnhancementSinkConfiguration() {
            return this.voiceEnhancementSinkConfiguration != null ? this.voiceEnhancementSinkConfiguration.toBuilder() : null;
        }

        public final void setVoiceEnhancementSinkConfiguration(VoiceEnhancementSinkConfiguration.BuilderImpl voiceEnhancementSinkConfiguration) {
            this.voiceEnhancementSinkConfiguration = voiceEnhancementSinkConfiguration != null ? voiceEnhancementSinkConfiguration.build() : null;
        }

        @Override
        public final Builder voiceEnhancementSinkConfiguration(VoiceEnhancementSinkConfiguration voiceEnhancementSinkConfiguration) {
            this.voiceEnhancementSinkConfiguration = voiceEnhancementSinkConfiguration;
            return this;
        }

        public MediaInsightsPipelineConfigurationElement build() {
            return new MediaInsightsPipelineConfigurationElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaInsightsPipelineConfigurationElement> {
        public Builder type(String var1);

        public Builder type(MediaInsightsPipelineConfigurationElementType var1);

        public Builder amazonTranscribeCallAnalyticsProcessorConfiguration(AmazonTranscribeCallAnalyticsProcessorConfiguration var1);

        default public Builder amazonTranscribeCallAnalyticsProcessorConfiguration(Consumer<AmazonTranscribeCallAnalyticsProcessorConfiguration.Builder> amazonTranscribeCallAnalyticsProcessorConfiguration) {
            return this.amazonTranscribeCallAnalyticsProcessorConfiguration((AmazonTranscribeCallAnalyticsProcessorConfiguration)((AmazonTranscribeCallAnalyticsProcessorConfiguration.Builder)AmazonTranscribeCallAnalyticsProcessorConfiguration.builder().applyMutation(amazonTranscribeCallAnalyticsProcessorConfiguration)).build());
        }

        public Builder amazonTranscribeProcessorConfiguration(AmazonTranscribeProcessorConfiguration var1);

        default public Builder amazonTranscribeProcessorConfiguration(Consumer<AmazonTranscribeProcessorConfiguration.Builder> amazonTranscribeProcessorConfiguration) {
            return this.amazonTranscribeProcessorConfiguration((AmazonTranscribeProcessorConfiguration)((AmazonTranscribeProcessorConfiguration.Builder)AmazonTranscribeProcessorConfiguration.builder().applyMutation(amazonTranscribeProcessorConfiguration)).build());
        }

        public Builder kinesisDataStreamSinkConfiguration(KinesisDataStreamSinkConfiguration var1);

        default public Builder kinesisDataStreamSinkConfiguration(Consumer<KinesisDataStreamSinkConfiguration.Builder> kinesisDataStreamSinkConfiguration) {
            return this.kinesisDataStreamSinkConfiguration((KinesisDataStreamSinkConfiguration)((KinesisDataStreamSinkConfiguration.Builder)KinesisDataStreamSinkConfiguration.builder().applyMutation(kinesisDataStreamSinkConfiguration)).build());
        }

        public Builder s3RecordingSinkConfiguration(S3RecordingSinkConfiguration var1);

        default public Builder s3RecordingSinkConfiguration(Consumer<S3RecordingSinkConfiguration.Builder> s3RecordingSinkConfiguration) {
            return this.s3RecordingSinkConfiguration((S3RecordingSinkConfiguration)((S3RecordingSinkConfiguration.Builder)S3RecordingSinkConfiguration.builder().applyMutation(s3RecordingSinkConfiguration)).build());
        }

        public Builder voiceAnalyticsProcessorConfiguration(VoiceAnalyticsProcessorConfiguration var1);

        default public Builder voiceAnalyticsProcessorConfiguration(Consumer<VoiceAnalyticsProcessorConfiguration.Builder> voiceAnalyticsProcessorConfiguration) {
            return this.voiceAnalyticsProcessorConfiguration((VoiceAnalyticsProcessorConfiguration)((VoiceAnalyticsProcessorConfiguration.Builder)VoiceAnalyticsProcessorConfiguration.builder().applyMutation(voiceAnalyticsProcessorConfiguration)).build());
        }

        public Builder lambdaFunctionSinkConfiguration(LambdaFunctionSinkConfiguration var1);

        default public Builder lambdaFunctionSinkConfiguration(Consumer<LambdaFunctionSinkConfiguration.Builder> lambdaFunctionSinkConfiguration) {
            return this.lambdaFunctionSinkConfiguration((LambdaFunctionSinkConfiguration)((LambdaFunctionSinkConfiguration.Builder)LambdaFunctionSinkConfiguration.builder().applyMutation(lambdaFunctionSinkConfiguration)).build());
        }

        public Builder sqsQueueSinkConfiguration(SqsQueueSinkConfiguration var1);

        default public Builder sqsQueueSinkConfiguration(Consumer<SqsQueueSinkConfiguration.Builder> sqsQueueSinkConfiguration) {
            return this.sqsQueueSinkConfiguration((SqsQueueSinkConfiguration)((SqsQueueSinkConfiguration.Builder)SqsQueueSinkConfiguration.builder().applyMutation(sqsQueueSinkConfiguration)).build());
        }

        public Builder snsTopicSinkConfiguration(SnsTopicSinkConfiguration var1);

        default public Builder snsTopicSinkConfiguration(Consumer<SnsTopicSinkConfiguration.Builder> snsTopicSinkConfiguration) {
            return this.snsTopicSinkConfiguration((SnsTopicSinkConfiguration)((SnsTopicSinkConfiguration.Builder)SnsTopicSinkConfiguration.builder().applyMutation(snsTopicSinkConfiguration)).build());
        }

        public Builder voiceEnhancementSinkConfiguration(VoiceEnhancementSinkConfiguration var1);

        default public Builder voiceEnhancementSinkConfiguration(Consumer<VoiceEnhancementSinkConfiguration.Builder> voiceEnhancementSinkConfiguration) {
            return this.voiceEnhancementSinkConfiguration((VoiceEnhancementSinkConfiguration)((VoiceEnhancementSinkConfiguration.Builder)VoiceEnhancementSinkConfiguration.builder().applyMutation(voiceEnhancementSinkConfiguration)).build());
        }
    }
}

