/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MediaPipelineSinkType {
    S3_BUCKET("S3Bucket"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MediaPipelineSinkType> VALUE_MAP;
    private final String value;

    private MediaPipelineSinkType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaPipelineSinkType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaPipelineSinkType> knownValues() {
        EnumSet<MediaPipelineSinkType> knownValues = EnumSet.allOf(MediaPipelineSinkType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MediaPipelineSinkType.class, MediaPipelineSinkType::toString);
    }
}

