/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAppInstanceRetentionSettingsResponse extends ChimeSdkIdentityResponse implements
        ToCopyableBuilder<GetAppInstanceRetentionSettingsResponse.Builder, GetAppInstanceRetentionSettingsResponse> {
    private static final SdkField<AppInstanceRetentionSettings> APP_INSTANCE_RETENTION_SETTINGS_FIELD = SdkField
            .<AppInstanceRetentionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("AppInstanceRetentionSettings")
            .getter(getter(GetAppInstanceRetentionSettingsResponse::appInstanceRetentionSettings))
            .setter(setter(Builder::appInstanceRetentionSettings))
            .constructor(AppInstanceRetentionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceRetentionSettings")
                    .build()).build();

    private static final SdkField<Instant> INITIATE_DELETION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("InitiateDeletionTimestamp")
            .getter(getter(GetAppInstanceRetentionSettingsResponse::initiateDeletionTimestamp))
            .setter(setter(Builder::initiateDeletionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiateDeletionTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APP_INSTANCE_RETENTION_SETTINGS_FIELD, INITIATE_DELETION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AppInstanceRetentionSettings appInstanceRetentionSettings;

    private final Instant initiateDeletionTimestamp;

    private GetAppInstanceRetentionSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceRetentionSettings = builder.appInstanceRetentionSettings;
        this.initiateDeletionTimestamp = builder.initiateDeletionTimestamp;
    }

    /**
     * <p>
     * The retention settings for the <code>AppInstance</code>.
     * </p>
     * 
     * @return The retention settings for the <code>AppInstance</code>.
     */
    public final AppInstanceRetentionSettings appInstanceRetentionSettings() {
        return appInstanceRetentionSettings;
    }

    /**
     * <p>
     * The timestamp representing the time at which the specified items are retained, in Epoch Seconds.
     * </p>
     * 
     * @return The timestamp representing the time at which the specified items are retained, in Epoch Seconds.
     */
    public final Instant initiateDeletionTimestamp() {
        return initiateDeletionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceRetentionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(initiateDeletionTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppInstanceRetentionSettingsResponse)) {
            return false;
        }
        GetAppInstanceRetentionSettingsResponse other = (GetAppInstanceRetentionSettingsResponse) obj;
        return Objects.equals(appInstanceRetentionSettings(), other.appInstanceRetentionSettings())
                && Objects.equals(initiateDeletionTimestamp(), other.initiateDeletionTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAppInstanceRetentionSettingsResponse")
                .add("AppInstanceRetentionSettings", appInstanceRetentionSettings())
                .add("InitiateDeletionTimestamp", initiateDeletionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceRetentionSettings":
            return Optional.ofNullable(clazz.cast(appInstanceRetentionSettings()));
        case "InitiateDeletionTimestamp":
            return Optional.ofNullable(clazz.cast(initiateDeletionTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppInstanceRetentionSettings", APP_INSTANCE_RETENTION_SETTINGS_FIELD);
        map.put("InitiateDeletionTimestamp", INITIATE_DELETION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAppInstanceRetentionSettingsResponse, T> g) {
        return obj -> g.apply((GetAppInstanceRetentionSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkIdentityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAppInstanceRetentionSettingsResponse> {
        /**
         * <p>
         * The retention settings for the <code>AppInstance</code>.
         * </p>
         * 
         * @param appInstanceRetentionSettings
         *        The retention settings for the <code>AppInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceRetentionSettings(AppInstanceRetentionSettings appInstanceRetentionSettings);

        /**
         * <p>
         * The retention settings for the <code>AppInstance</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppInstanceRetentionSettings.Builder}
         * avoiding the need to create one manually via {@link AppInstanceRetentionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppInstanceRetentionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #appInstanceRetentionSettings(AppInstanceRetentionSettings)}.
         * 
         * @param appInstanceRetentionSettings
         *        a consumer that will call methods on {@link AppInstanceRetentionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appInstanceRetentionSettings(AppInstanceRetentionSettings)
         */
        default Builder appInstanceRetentionSettings(Consumer<AppInstanceRetentionSettings.Builder> appInstanceRetentionSettings) {
            return appInstanceRetentionSettings(AppInstanceRetentionSettings.builder()
                    .applyMutation(appInstanceRetentionSettings).build());
        }

        /**
         * <p>
         * The timestamp representing the time at which the specified items are retained, in Epoch Seconds.
         * </p>
         * 
         * @param initiateDeletionTimestamp
         *        The timestamp representing the time at which the specified items are retained, in Epoch Seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiateDeletionTimestamp(Instant initiateDeletionTimestamp);
    }

    static final class BuilderImpl extends ChimeSdkIdentityResponse.BuilderImpl implements Builder {
        private AppInstanceRetentionSettings appInstanceRetentionSettings;

        private Instant initiateDeletionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppInstanceRetentionSettingsResponse model) {
            super(model);
            appInstanceRetentionSettings(model.appInstanceRetentionSettings);
            initiateDeletionTimestamp(model.initiateDeletionTimestamp);
        }

        public final AppInstanceRetentionSettings.Builder getAppInstanceRetentionSettings() {
            return appInstanceRetentionSettings != null ? appInstanceRetentionSettings.toBuilder() : null;
        }

        public final void setAppInstanceRetentionSettings(AppInstanceRetentionSettings.BuilderImpl appInstanceRetentionSettings) {
            this.appInstanceRetentionSettings = appInstanceRetentionSettings != null ? appInstanceRetentionSettings.build()
                    : null;
        }

        @Override
        public final Builder appInstanceRetentionSettings(AppInstanceRetentionSettings appInstanceRetentionSettings) {
            this.appInstanceRetentionSettings = appInstanceRetentionSettings;
            return this;
        }

        public final Instant getInitiateDeletionTimestamp() {
            return initiateDeletionTimestamp;
        }

        public final void setInitiateDeletionTimestamp(Instant initiateDeletionTimestamp) {
            this.initiateDeletionTimestamp = initiateDeletionTimestamp;
        }

        @Override
        public final Builder initiateDeletionTimestamp(Instant initiateDeletionTimestamp) {
            this.initiateDeletionTimestamp = initiateDeletionTimestamp;
            return this;
        }

        @Override
        public GetAppInstanceRetentionSettingsResponse build() {
            return new GetAppInstanceRetentionSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
