/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains configuration data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Configuration implements SdkPojo, Serializable, ToCopyableBuilder<Configuration.Builder, Configuration> {
    private static final SdkField<LexConfiguration> LEX_FIELD = SdkField.<LexConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("Lex").getter(getter(Configuration::lex)).setter(setter(Builder::lex))
            .constructor(LexConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LexConfiguration lex;

    private Configuration(BuilderImpl builder) {
        this.lex = builder.lex;
    }

    /**
     * <p>
     * The configuration for an Amazon Lex V2 bot.
     * </p>
     * 
     * @return The configuration for an Amazon Lex V2 bot.
     */
    public final LexConfiguration lex() {
        return lex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration) obj;
        return Objects.equals(lex(), other.lex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Configuration").add("Lex", lex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Lex":
            return Optional.ofNullable(clazz.cast(lex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Lex", LEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Configuration, T> g) {
        return obj -> g.apply((Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Configuration> {
        /**
         * <p>
         * The configuration for an Amazon Lex V2 bot.
         * </p>
         * 
         * @param lex
         *        The configuration for an Amazon Lex V2 bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lex(LexConfiguration lex);

        /**
         * <p>
         * The configuration for an Amazon Lex V2 bot.
         * </p>
         * This is a convenience method that creates an instance of the {@link LexConfiguration.Builder} avoiding the
         * need to create one manually via {@link LexConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LexConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #lex(LexConfiguration)}.
         * 
         * @param lex
         *        a consumer that will call methods on {@link LexConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lex(LexConfiguration)
         */
        default Builder lex(Consumer<LexConfiguration.Builder> lex) {
            return lex(LexConfiguration.builder().applyMutation(lex).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LexConfiguration lex;

        private BuilderImpl() {
        }

        private BuilderImpl(Configuration model) {
            lex(model.lex);
        }

        public final LexConfiguration.Builder getLex() {
            return lex != null ? lex.toBuilder() : null;
        }

        public final void setLex(LexConfiguration.BuilderImpl lex) {
            this.lex = lex != null ? lex.build() : null;
        }

        @Override
        public final Builder lex(LexConfiguration lex) {
            this.lex = lex;
            return this;
        }

        @Override
        public Configuration build() {
            return new Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
