/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * High-level information about an AppInstanceBot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppInstanceBotSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AppInstanceBotSummary.Builder, AppInstanceBotSummary> {
    private static final SdkField<String> APP_INSTANCE_BOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceBotArn").getter(getter(AppInstanceBotSummary::appInstanceBotArn))
            .setter(setter(Builder::appInstanceBotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceBotArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AppInstanceBotSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(AppInstanceBotSummary::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_BOT_ARN_FIELD,
            NAME_FIELD, METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appInstanceBotArn;

    private final String name;

    private final String metadata;

    private AppInstanceBotSummary(BuilderImpl builder) {
        this.appInstanceBotArn = builder.appInstanceBotArn;
        this.name = builder.name;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The ARN of the AppInstanceBot.
     * </p>
     * 
     * @return The ARN of the AppInstanceBot.
     */
    public final String appInstanceBotArn() {
        return appInstanceBotArn;
    }

    /**
     * <p>
     * The name of the AppInstanceBox.
     * </p>
     * 
     * @return The name of the AppInstanceBox.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The metadata of the AppInstanceBot.
     * </p>
     * 
     * @return The metadata of the AppInstanceBot.
     */
    public final String metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceBotArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceBotSummary)) {
            return false;
        }
        AppInstanceBotSummary other = (AppInstanceBotSummary) obj;
        return Objects.equals(appInstanceBotArn(), other.appInstanceBotArn()) && Objects.equals(name(), other.name())
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppInstanceBotSummary").add("AppInstanceBotArn", appInstanceBotArn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceBotArn":
            return Optional.ofNullable(clazz.cast(appInstanceBotArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppInstanceBotArn", APP_INSTANCE_BOT_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceBotSummary, T> g) {
        return obj -> g.apply((AppInstanceBotSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppInstanceBotSummary> {
        /**
         * <p>
         * The ARN of the AppInstanceBot.
         * </p>
         * 
         * @param appInstanceBotArn
         *        The ARN of the AppInstanceBot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceBotArn(String appInstanceBotArn);

        /**
         * <p>
         * The name of the AppInstanceBox.
         * </p>
         * 
         * @param name
         *        The name of the AppInstanceBox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The metadata of the AppInstanceBot.
         * </p>
         * 
         * @param metadata
         *        The metadata of the AppInstanceBot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);
    }

    static final class BuilderImpl implements Builder {
        private String appInstanceBotArn;

        private String name;

        private String metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceBotSummary model) {
            appInstanceBotArn(model.appInstanceBotArn);
            name(model.name);
            metadata(model.metadata);
        }

        public final String getAppInstanceBotArn() {
            return appInstanceBotArn;
        }

        public final void setAppInstanceBotArn(String appInstanceBotArn) {
            this.appInstanceBotArn = appInstanceBotArn;
        }

        @Override
        public final Builder appInstanceBotArn(String appInstanceBotArn) {
            this.appInstanceBotArn = appInstanceBotArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public AppInstanceBotSummary build() {
            return new AppInstanceBotSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
