/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkidentity.ChimeSdkIdentityAsyncClient;
import software.amazon.awssdk.services.chimesdkidentity.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUserEndpointsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUserEndpointsResponse;

public class ListAppInstanceUserEndpointsPublisher
implements SdkPublisher<ListAppInstanceUserEndpointsResponse> {
    private final ChimeSdkIdentityAsyncClient client;
    private final ListAppInstanceUserEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppInstanceUserEndpointsPublisher(ChimeSdkIdentityAsyncClient client, ListAppInstanceUserEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppInstanceUserEndpointsPublisher(ChimeSdkIdentityAsyncClient client, ListAppInstanceUserEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppInstanceUserEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppInstanceUserEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppInstanceUserEndpointsResponseFetcher
    implements AsyncPageFetcher<ListAppInstanceUserEndpointsResponse> {
        private ListAppInstanceUserEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppInstanceUserEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppInstanceUserEndpointsResponse> nextPage(ListAppInstanceUserEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListAppInstanceUserEndpointsPublisher.this.client.listAppInstanceUserEndpoints(ListAppInstanceUserEndpointsPublisher.this.firstRequest);
            }
            return ListAppInstanceUserEndpointsPublisher.this.client.listAppInstanceUserEndpoints((ListAppInstanceUserEndpointsRequest)((Object)ListAppInstanceUserEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

