/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkidentity.ChimeSdkIdentityClient;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersResponse;

public class ListAppInstanceUsersIterable
implements SdkIterable<ListAppInstanceUsersResponse> {
    private final ChimeSdkIdentityClient client;
    private final ListAppInstanceUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppInstanceUsersIterable(ChimeSdkIdentityClient client, ListAppInstanceUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAppInstanceUsersResponseFetcher();
    }

    public Iterator<ListAppInstanceUsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAppInstanceUsersResponseFetcher
    implements SyncPageFetcher<ListAppInstanceUsersResponse> {
        private ListAppInstanceUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListAppInstanceUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppInstanceUsersResponse nextPage(ListAppInstanceUsersResponse previousPage) {
            if (previousPage == null) {
                return ListAppInstanceUsersIterable.this.client.listAppInstanceUsers(ListAppInstanceUsersIterable.this.firstRequest);
            }
            return ListAppInstanceUsersIterable.this.client.listAppInstanceUsers((ListAppInstanceUsersRequest)((Object)ListAppInstanceUsersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

