/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.chimesdkidentity.ChimeSdkIdentityClient;
import software.amazon.awssdk.services.chimesdkidentity.model.BadRequestException;
import software.amazon.awssdk.services.chimesdkidentity.model.ChimeSdkIdentityException;
import software.amazon.awssdk.services.chimesdkidentity.model.ChimeSdkIdentityRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ConflictException;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceAdminRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceAdminResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.CreateAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceAdminRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceAdminResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DeleteAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceAdminRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceAdminResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.DescribeAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ForbiddenException;
import software.amazon.awssdk.services.chimesdkidentity.model.GetAppInstanceRetentionSettingsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.GetAppInstanceRetentionSettingsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceUsersResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstancesResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.PutAppInstanceRetentionSettingsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.PutAppInstanceRetentionSettingsResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.chimesdkidentity.model.ServiceFailureException;
import software.amazon.awssdk.services.chimesdkidentity.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chimesdkidentity.model.ThrottledClientException;
import software.amazon.awssdk.services.chimesdkidentity.model.UnauthorizedClientException;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceResponse;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceUserRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.UpdateAppInstanceUserResponse;
import software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceAdminsIterable;
import software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstanceUsersIterable;
import software.amazon.awssdk.services.chimesdkidentity.paginators.ListAppInstancesIterable;
import software.amazon.awssdk.services.chimesdkidentity.transform.CreateAppInstanceAdminRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.CreateAppInstanceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.CreateAppInstanceUserRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DeleteAppInstanceAdminRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DeleteAppInstanceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DeleteAppInstanceUserRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DescribeAppInstanceAdminRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DescribeAppInstanceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.DescribeAppInstanceUserRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.GetAppInstanceRetentionSettingsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.ListAppInstanceAdminsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.ListAppInstanceUsersRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.ListAppInstancesRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.PutAppInstanceRetentionSettingsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.UpdateAppInstanceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkidentity.transform.UpdateAppInstanceUserRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultChimeSdkIdentityClient
implements ChimeSdkIdentityClient {
    private static final Logger log = Logger.loggerFor(DefaultChimeSdkIdentityClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultChimeSdkIdentityClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "chime";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAppInstanceResponse createAppInstance(CreateAppInstanceRequest createAppInstanceRequest) throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAppInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, createAppInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAppInstance");
            CreateAppInstanceResponse createAppInstanceResponse = (CreateAppInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAppInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAppInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAppInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAppInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$createAppInstance$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAppInstanceAdminResponse createAppInstanceAdmin(CreateAppInstanceAdminRequest createAppInstanceAdminRequest) throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAppInstanceAdminResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, createAppInstanceAdminRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAppInstanceAdmin");
            CreateAppInstanceAdminResponse createAppInstanceAdminResponse = (CreateAppInstanceAdminResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAppInstanceAdmin").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAppInstanceAdminRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAppInstanceAdminRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAppInstanceAdminResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$createAppInstanceAdmin$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAppInstanceUserResponse createAppInstanceUser(CreateAppInstanceUserRequest createAppInstanceUserRequest) throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAppInstanceUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, createAppInstanceUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAppInstanceUser");
            CreateAppInstanceUserResponse createAppInstanceUserResponse = (CreateAppInstanceUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAppInstanceUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAppInstanceUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAppInstanceUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAppInstanceUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$createAppInstanceUser$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppInstanceResponse deleteAppInstance(DeleteAppInstanceRequest deleteAppInstanceRequest) throws BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, deleteAppInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppInstance");
            DeleteAppInstanceResponse deleteAppInstanceResponse = (DeleteAppInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAppInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$deleteAppInstance$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppInstanceAdminResponse deleteAppInstanceAdmin(DeleteAppInstanceAdminRequest deleteAppInstanceAdminRequest) throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppInstanceAdminResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, deleteAppInstanceAdminRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppInstanceAdmin");
            DeleteAppInstanceAdminResponse deleteAppInstanceAdminResponse = (DeleteAppInstanceAdminResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppInstanceAdmin").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAppInstanceAdminRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppInstanceAdminRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppInstanceAdminResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$deleteAppInstanceAdmin$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppInstanceUserResponse deleteAppInstanceUser(DeleteAppInstanceUserRequest deleteAppInstanceUserRequest) throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppInstanceUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, deleteAppInstanceUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppInstanceUser");
            DeleteAppInstanceUserResponse deleteAppInstanceUserResponse = (DeleteAppInstanceUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppInstanceUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAppInstanceUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppInstanceUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppInstanceUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$deleteAppInstanceUser$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAppInstanceResponse describeAppInstance(DescribeAppInstanceRequest describeAppInstanceRequest) throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAppInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, describeAppInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAppInstance");
            DescribeAppInstanceResponse describeAppInstanceResponse = (DescribeAppInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAppInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAppInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAppInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAppInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$describeAppInstance$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAppInstanceAdminResponse describeAppInstanceAdmin(DescribeAppInstanceAdminRequest describeAppInstanceAdminRequest) throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAppInstanceAdminResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, describeAppInstanceAdminRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAppInstanceAdmin");
            DescribeAppInstanceAdminResponse describeAppInstanceAdminResponse = (DescribeAppInstanceAdminResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAppInstanceAdmin").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAppInstanceAdminRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAppInstanceAdminRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAppInstanceAdminResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$describeAppInstanceAdmin$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAppInstanceUserResponse describeAppInstanceUser(DescribeAppInstanceUserRequest describeAppInstanceUserRequest) throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAppInstanceUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, describeAppInstanceUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAppInstanceUser");
            DescribeAppInstanceUserResponse describeAppInstanceUserResponse = (DescribeAppInstanceUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAppInstanceUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAppInstanceUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAppInstanceUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAppInstanceUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$describeAppInstanceUser$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppInstanceRetentionSettingsResponse getAppInstanceRetentionSettings(GetAppInstanceRetentionSettingsRequest getAppInstanceRetentionSettingsRequest) throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppInstanceRetentionSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, getAppInstanceRetentionSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppInstanceRetentionSettings");
            GetAppInstanceRetentionSettingsResponse getAppInstanceRetentionSettingsResponse = (GetAppInstanceRetentionSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppInstanceRetentionSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAppInstanceRetentionSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppInstanceRetentionSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppInstanceRetentionSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$getAppInstanceRetentionSettings$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAppInstanceAdminsResponse listAppInstanceAdmins(ListAppInstanceAdminsRequest listAppInstanceAdminsRequest) throws BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAppInstanceAdminsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, listAppInstanceAdminsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAppInstanceAdmins");
            ListAppInstanceAdminsResponse listAppInstanceAdminsResponse = (ListAppInstanceAdminsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAppInstanceAdmins").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAppInstanceAdminsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAppInstanceAdminsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAppInstanceAdminsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$listAppInstanceAdmins$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAppInstanceAdminsIterable listAppInstanceAdminsPaginator(ListAppInstanceAdminsRequest listAppInstanceAdminsRequest) throws BadRequestException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        return new ListAppInstanceAdminsIterable(this, this.applyPaginatorUserAgent(listAppInstanceAdminsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAppInstanceUsersResponse listAppInstanceUsers(ListAppInstanceUsersRequest listAppInstanceUsersRequest) throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAppInstanceUsersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, listAppInstanceUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAppInstanceUsers");
            ListAppInstanceUsersResponse listAppInstanceUsersResponse = (ListAppInstanceUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAppInstanceUsers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAppInstanceUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAppInstanceUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAppInstanceUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$listAppInstanceUsers$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAppInstanceUsersIterable listAppInstanceUsersPaginator(ListAppInstanceUsersRequest listAppInstanceUsersRequest) throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        return new ListAppInstanceUsersIterable(this, this.applyPaginatorUserAgent(listAppInstanceUsersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAppInstancesResponse listAppInstances(ListAppInstancesRequest listAppInstancesRequest) throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAppInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, listAppInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAppInstances");
            ListAppInstancesResponse listAppInstancesResponse = (ListAppInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAppInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAppInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAppInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAppInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$listAppInstances$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAppInstancesIterable listAppInstancesPaginator(ListAppInstancesRequest listAppInstancesRequest) throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        return new ListAppInstancesIterable(this, this.applyPaginatorUserAgent(listAppInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAppInstanceRetentionSettingsResponse putAppInstanceRetentionSettings(PutAppInstanceRetentionSettingsRequest putAppInstanceRetentionSettingsRequest) throws BadRequestException, ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAppInstanceRetentionSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, putAppInstanceRetentionSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAppInstanceRetentionSettings");
            PutAppInstanceRetentionSettingsResponse putAppInstanceRetentionSettingsResponse = (PutAppInstanceRetentionSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAppInstanceRetentionSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAppInstanceRetentionSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAppInstanceRetentionSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAppInstanceRetentionSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$putAppInstanceRetentionSettings$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAppInstanceResponse updateAppInstance(UpdateAppInstanceRequest updateAppInstanceRequest) throws BadRequestException, ConflictException, ForbiddenException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAppInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, updateAppInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAppInstance");
            UpdateAppInstanceResponse updateAppInstanceResponse = (UpdateAppInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAppInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAppInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAppInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAppInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$updateAppInstance$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAppInstanceUserResponse updateAppInstanceUser(UpdateAppInstanceUserRequest updateAppInstanceUserRequest) throws BadRequestException, ConflictException, ForbiddenException, ResourceLimitExceededException, ThrottledClientException, UnauthorizedClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAppInstanceUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultChimeSdkIdentityClient.resolveMetricPublishers(this.clientConfiguration, updateAppInstanceUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Chime SDK Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAppInstanceUser");
            UpdateAppInstanceUserResponse updateAppInstanceUserResponse = (UpdateAppInstanceUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAppInstanceUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAppInstanceUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAppInstanceUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAppInstanceUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultChimeSdkIdentityClient.lambda$updateAppInstanceUser$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ChimeSdkIdentityException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").exceptionBuilderSupplier(UnauthorizedClientException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottledClientException").exceptionBuilderSupplier(ThrottledClientException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ForbiddenException").exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceFailureException").exceptionBuilderSupplier(ServiceFailureException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ChimeSdkIdentityRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.37").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ChimeSdkIdentityRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateAppInstanceUser$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAppInstance$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAppInstanceRetentionSettings$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAppInstances$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAppInstanceUsers$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAppInstanceAdmins$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppInstanceRetentionSettings$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAppInstanceUser$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAppInstanceAdmin$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAppInstance$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppInstanceUser$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppInstanceAdmin$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppInstance$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAppInstanceUser$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAppInstanceAdmin$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAppInstance$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

