/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.Invite;
import software.amazon.awssdk.services.chime.model.InviteListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InviteUsersResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, InviteUsersResponse> {
    private static final SdkField<List<Invite>> INVITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InviteUsersResponse.getter(InviteUsersResponse::invites)).setter(InviteUsersResponse.setter(Builder::invites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Invites").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Invite::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITES_FIELD));
    private final List<Invite> invites;

    private InviteUsersResponse(BuilderImpl builder) {
        super(builder);
        this.invites = builder.invites;
    }

    public List<Invite> invites() {
        return this.invites;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invites());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InviteUsersResponse)) {
            return false;
        }
        InviteUsersResponse other = (InviteUsersResponse)((Object)obj);
        return Objects.equals(this.invites(), other.invites());
    }

    public String toString() {
        return ToString.builder((String)"InviteUsersResponse").add("Invites", this.invites()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Invites": {
                return Optional.ofNullable(clazz.cast(this.invites()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InviteUsersResponse, T> g) {
        return obj -> g.apply((InviteUsersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<Invite> invites = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InviteUsersResponse model) {
            super(model);
            this.invites(model.invites);
        }

        public final Collection<Invite.Builder> getInvites() {
            return this.invites != null ? (Collection)this.invites.stream().map(Invite::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder invites(Collection<Invite> invites) {
            this.invites = InviteListCopier.copy(invites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invites(Invite ... invites) {
            this.invites(Arrays.asList(invites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invites(Consumer<Invite.Builder> ... invites) {
            this.invites(Stream.of(invites).map(c -> (Invite)((Invite.Builder)Invite.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInvites(Collection<Invite.BuilderImpl> invites) {
            this.invites = InviteListCopier.copyFromBuilder(invites);
        }

        @Override
        public InviteUsersResponse build() {
            return new InviteUsersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InviteUsersResponse> {
        public Builder invites(Collection<Invite> var1);

        public Builder invites(Invite ... var1);

        public Builder invites(Consumer<Invite.Builder> ... var1);
    }
}

