/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.BusinessCallingSettings;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.VoiceConnectorSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGlobalSettingsRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, UpdateGlobalSettingsRequest> {
    private static final SdkField<BusinessCallingSettings> BUSINESS_CALLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateGlobalSettingsRequest.getter(UpdateGlobalSettingsRequest::businessCalling)).setter(UpdateGlobalSettingsRequest.setter(Builder::businessCalling)).constructor(BusinessCallingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessCalling").build()}).build();
    private static final SdkField<VoiceConnectorSettings> VOICE_CONNECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateGlobalSettingsRequest.getter(UpdateGlobalSettingsRequest::voiceConnector)).setter(UpdateGlobalSettingsRequest.setter(Builder::voiceConnector)).constructor(VoiceConnectorSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_CALLING_FIELD, VOICE_CONNECTOR_FIELD));
    private final BusinessCallingSettings businessCalling;
    private final VoiceConnectorSettings voiceConnector;

    private UpdateGlobalSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.businessCalling = builder.businessCalling;
        this.voiceConnector = builder.voiceConnector;
    }

    public BusinessCallingSettings businessCalling() {
        return this.businessCalling;
    }

    public VoiceConnectorSettings voiceConnector() {
        return this.voiceConnector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.businessCalling());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnector());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalSettingsRequest)) {
            return false;
        }
        UpdateGlobalSettingsRequest other = (UpdateGlobalSettingsRequest)((Object)obj);
        return Objects.equals(this.businessCalling(), other.businessCalling()) && Objects.equals(this.voiceConnector(), other.voiceConnector());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGlobalSettingsRequest").add("BusinessCalling", (Object)this.businessCalling()).add("VoiceConnector", (Object)this.voiceConnector()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BusinessCalling": {
                return Optional.ofNullable(clazz.cast(this.businessCalling()));
            }
            case "VoiceConnector": {
                return Optional.ofNullable(clazz.cast(this.voiceConnector()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalSettingsRequest, T> g) {
        return obj -> g.apply((UpdateGlobalSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private BusinessCallingSettings businessCalling;
        private VoiceConnectorSettings voiceConnector;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalSettingsRequest model) {
            super(model);
            this.businessCalling(model.businessCalling);
            this.voiceConnector(model.voiceConnector);
        }

        public final BusinessCallingSettings.Builder getBusinessCalling() {
            return this.businessCalling != null ? this.businessCalling.toBuilder() : null;
        }

        @Override
        public final Builder businessCalling(BusinessCallingSettings businessCalling) {
            this.businessCalling = businessCalling;
            return this;
        }

        public final void setBusinessCalling(BusinessCallingSettings.BuilderImpl businessCalling) {
            this.businessCalling = businessCalling != null ? businessCalling.build() : null;
        }

        public final VoiceConnectorSettings.Builder getVoiceConnector() {
            return this.voiceConnector != null ? this.voiceConnector.toBuilder() : null;
        }

        @Override
        public final Builder voiceConnector(VoiceConnectorSettings voiceConnector) {
            this.voiceConnector = voiceConnector;
            return this;
        }

        public final void setVoiceConnector(VoiceConnectorSettings.BuilderImpl voiceConnector) {
            this.voiceConnector = voiceConnector != null ? voiceConnector.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGlobalSettingsRequest build() {
            return new UpdateGlobalSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGlobalSettingsRequest> {
        public Builder businessCalling(BusinessCallingSettings var1);

        default public Builder businessCalling(Consumer<BusinessCallingSettings.Builder> businessCalling) {
            return this.businessCalling((BusinessCallingSettings)((BusinessCallingSettings.Builder)BusinessCallingSettings.builder().applyMutation(businessCalling)).build());
        }

        public Builder voiceConnector(VoiceConnectorSettings var1);

        default public Builder voiceConnector(Consumer<VoiceConnectorSettings.Builder> voiceConnector) {
            return this.voiceConnector((VoiceConnectorSettings)((VoiceConnectorSettings.Builder)VoiceConnectorSettings.builder().applyMutation(voiceConnector)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

