/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.OrderedPhoneNumberStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrderedPhoneNumber
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrderedPhoneNumber> {
    private static final SdkField<String> E164_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("E164PhoneNumber").getter(OrderedPhoneNumber.getter(OrderedPhoneNumber::e164PhoneNumber)).setter(OrderedPhoneNumber.setter(Builder::e164PhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(OrderedPhoneNumber.getter(OrderedPhoneNumber::statusAsString)).setter(OrderedPhoneNumber.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E164_PHONE_NUMBER_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrderedPhoneNumber.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String e164PhoneNumber;
    private final String status;

    private OrderedPhoneNumber(BuilderImpl builder) {
        this.e164PhoneNumber = builder.e164PhoneNumber;
        this.status = builder.status;
    }

    public final String e164PhoneNumber() {
        return this.e164PhoneNumber;
    }

    public final OrderedPhoneNumberStatus status() {
        return OrderedPhoneNumberStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.e164PhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderedPhoneNumber)) {
            return false;
        }
        OrderedPhoneNumber other = (OrderedPhoneNumber)obj;
        return Objects.equals(this.e164PhoneNumber(), other.e164PhoneNumber()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OrderedPhoneNumber").add("E164PhoneNumber", (Object)(this.e164PhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "E164PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.e164PhoneNumber()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("E164PhoneNumber", E164_PHONE_NUMBER_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrderedPhoneNumber, T> g) {
        return obj -> g.apply((OrderedPhoneNumber)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String e164PhoneNumber;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderedPhoneNumber model) {
            this.e164PhoneNumber(model.e164PhoneNumber);
            this.status(model.status);
        }

        public final String getE164PhoneNumber() {
            return this.e164PhoneNumber;
        }

        public final void setE164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
        }

        @Override
        public final Builder e164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrderedPhoneNumberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public OrderedPhoneNumber build() {
            return new OrderedPhoneNumber(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrderedPhoneNumber> {
        public Builder e164PhoneNumber(String var1);

        public Builder status(String var1);

        public Builder status(OrderedPhoneNumberStatus var1);
    }
}

