/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountRequest extends ChimeRequest implements
        ToCopyableBuilder<UpdateAccountRequest.Builder, UpdateAccountRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(UpdateAccountRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAccountRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DEFAULT_LICENSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultLicense").getter(getter(UpdateAccountRequest::defaultLicenseAsString))
            .setter(setter(Builder::defaultLicense))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultLicense").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, NAME_FIELD,
            DEFAULT_LICENSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String name;

    private final String defaultLicense;

    private UpdateAccountRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.name = builder.name;
        this.defaultLicense = builder.defaultLicense;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The new name for the specified Amazon Chime account.
     * </p>
     * 
     * @return The new name for the specified Amazon Chime account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The default license applied when you add users to an Amazon Chime account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultLicense}
     * will return {@link License#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultLicenseAsString}.
     * </p>
     * 
     * @return The default license applied when you add users to an Amazon Chime account.
     * @see License
     */
    public final License defaultLicense() {
        return License.fromValue(defaultLicense);
    }

    /**
     * <p>
     * The default license applied when you add users to an Amazon Chime account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultLicense}
     * will return {@link License#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultLicenseAsString}.
     * </p>
     * 
     * @return The default license applied when you add users to an Amazon Chime account.
     * @see License
     */
    public final String defaultLicenseAsString() {
        return defaultLicense;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(defaultLicenseAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountRequest)) {
            return false;
        }
        UpdateAccountRequest other = (UpdateAccountRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(name(), other.name())
                && Objects.equals(defaultLicenseAsString(), other.defaultLicenseAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountRequest").add("AccountId", accountId()).add("Name", name())
                .add("DefaultLicense", defaultLicenseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DefaultLicense":
            return Optional.ofNullable(clazz.cast(defaultLicenseAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DefaultLicense", DEFAULT_LICENSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountRequest, T> g) {
        return obj -> g.apply((UpdateAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccountRequest> {
        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The new name for the specified Amazon Chime account.
         * </p>
         * 
         * @param name
         *        The new name for the specified Amazon Chime account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The default license applied when you add users to an Amazon Chime account.
         * </p>
         * 
         * @param defaultLicense
         *        The default license applied when you add users to an Amazon Chime account.
         * @see License
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see License
         */
        Builder defaultLicense(String defaultLicense);

        /**
         * <p>
         * The default license applied when you add users to an Amazon Chime account.
         * </p>
         * 
         * @param defaultLicense
         *        The default license applied when you add users to an Amazon Chime account.
         * @see License
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see License
         */
        Builder defaultLicense(License defaultLicense);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String accountId;

        private String name;

        private String defaultLicense;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountRequest model) {
            super(model);
            accountId(model.accountId);
            name(model.name);
            defaultLicense(model.defaultLicense);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDefaultLicense() {
            return defaultLicense;
        }

        public final void setDefaultLicense(String defaultLicense) {
            this.defaultLicense = defaultLicense;
        }

        @Override
        public final Builder defaultLicense(String defaultLicense) {
            this.defaultLicense = defaultLicense;
            return this;
        }

        @Override
        public final Builder defaultLicense(License defaultLicense) {
            this.defaultLicense(defaultLicense == null ? null : defaultLicense.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountRequest build() {
            return new UpdateAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
