/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhoneNumberError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhoneNumberError> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberId").getter(PhoneNumberError.getter(PhoneNumberError::phoneNumberId)).setter(PhoneNumberError.setter(Builder::phoneNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(PhoneNumberError.getter(PhoneNumberError::errorCodeAsString)).setter(PhoneNumberError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(PhoneNumberError.getter(PhoneNumberError::errorMessage)).setter(PhoneNumberError.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PhoneNumberError.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String phoneNumberId;
    private final String errorCode;
    private final String errorMessage;

    private PhoneNumberError(BuilderImpl builder) {
        this.phoneNumberId = builder.phoneNumberId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public final String phoneNumberId() {
        return this.phoneNumberId;
    }

    public final ErrorCode errorCode() {
        return ErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberError)) {
            return false;
        }
        PhoneNumberError other = (PhoneNumberError)obj;
        return Objects.equals(this.phoneNumberId(), other.phoneNumberId()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"PhoneNumberError").add("PhoneNumberId", (Object)this.phoneNumberId()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberId": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberId()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PhoneNumberId", PHONE_NUMBER_ID_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberError, T> g) {
        return obj -> g.apply((PhoneNumberError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String phoneNumberId;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberError model) {
            this.phoneNumberId(model.phoneNumberId);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getPhoneNumberId() {
            return this.phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public PhoneNumberError build() {
            return new PhoneNumberError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhoneNumberError> {
        public Builder phoneNumberId(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(ErrorCode var1);

        public Builder errorMessage(String var1);
    }
}

