/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Address
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Address> {
    private static final SdkField<String> STREET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streetName").getter(Address.getter(Address::streetName)).setter(Address.setter(Builder::streetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streetName").build()}).build();
    private static final SdkField<String> STREET_SUFFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streetSuffix").getter(Address.getter(Address::streetSuffix)).setter(Address.setter(Builder::streetSuffix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streetSuffix").build()}).build();
    private static final SdkField<String> POST_DIRECTIONAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("postDirectional").getter(Address.getter(Address::postDirectional)).setter(Address.setter(Builder::postDirectional)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postDirectional").build()}).build();
    private static final SdkField<String> PRE_DIRECTIONAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("preDirectional").getter(Address.getter(Address::preDirectional)).setter(Address.setter(Builder::preDirectional)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preDirectional").build()}).build();
    private static final SdkField<String> STREET_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streetNumber").getter(Address.getter(Address::streetNumber)).setter(Address.setter(Builder::streetNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streetNumber").build()}).build();
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("city").getter(Address.getter(Address::city)).setter(Address.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("city").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Address.getter(Address::state)).setter(Address.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("postalCode").getter(Address.getter(Address::postalCode)).setter(Address.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postalCode").build()}).build();
    private static final SdkField<String> POSTAL_CODE_PLUS4_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("postalCodePlus4").getter(Address.getter(Address::postalCodePlus4)).setter(Address.setter(Builder::postalCodePlus4)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postalCodePlus4").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("country").getter(Address.getter(Address::country)).setter(Address.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("country").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREET_NAME_FIELD, STREET_SUFFIX_FIELD, POST_DIRECTIONAL_FIELD, PRE_DIRECTIONAL_FIELD, STREET_NUMBER_FIELD, CITY_FIELD, STATE_FIELD, POSTAL_CODE_FIELD, POSTAL_CODE_PLUS4_FIELD, COUNTRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Address.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String streetName;
    private final String streetSuffix;
    private final String postDirectional;
    private final String preDirectional;
    private final String streetNumber;
    private final String city;
    private final String state;
    private final String postalCode;
    private final String postalCodePlus4;
    private final String country;

    private Address(BuilderImpl builder) {
        this.streetName = builder.streetName;
        this.streetSuffix = builder.streetSuffix;
        this.postDirectional = builder.postDirectional;
        this.preDirectional = builder.preDirectional;
        this.streetNumber = builder.streetNumber;
        this.city = builder.city;
        this.state = builder.state;
        this.postalCode = builder.postalCode;
        this.postalCodePlus4 = builder.postalCodePlus4;
        this.country = builder.country;
    }

    public final String streetName() {
        return this.streetName;
    }

    public final String streetSuffix() {
        return this.streetSuffix;
    }

    public final String postDirectional() {
        return this.postDirectional;
    }

    public final String preDirectional() {
        return this.preDirectional;
    }

    public final String streetNumber() {
        return this.streetNumber;
    }

    public final String city() {
        return this.city;
    }

    public final String state() {
        return this.state;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public final String postalCodePlus4() {
        return this.postalCodePlus4;
    }

    public final String country() {
        return this.country;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streetSuffix());
        hashCode = 31 * hashCode + Objects.hashCode(this.postDirectional());
        hashCode = 31 * hashCode + Objects.hashCode(this.preDirectional());
        hashCode = 31 * hashCode + Objects.hashCode(this.streetNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCodePlus4());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.streetName(), other.streetName()) && Objects.equals(this.streetSuffix(), other.streetSuffix()) && Objects.equals(this.postDirectional(), other.postDirectional()) && Objects.equals(this.preDirectional(), other.preDirectional()) && Objects.equals(this.streetNumber(), other.streetNumber()) && Objects.equals(this.city(), other.city()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.postalCodePlus4(), other.postalCodePlus4()) && Objects.equals(this.country(), other.country());
    }

    public final String toString() {
        return ToString.builder((String)"Address").add("StreetName", (Object)(this.streetName() == null ? null : "*** Sensitive Data Redacted ***")).add("StreetSuffix", (Object)(this.streetSuffix() == null ? null : "*** Sensitive Data Redacted ***")).add("PostDirectional", (Object)(this.postDirectional() == null ? null : "*** Sensitive Data Redacted ***")).add("PreDirectional", (Object)(this.preDirectional() == null ? null : "*** Sensitive Data Redacted ***")).add("StreetNumber", (Object)(this.streetNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("City", (Object)(this.city() == null ? null : "*** Sensitive Data Redacted ***")).add("State", (Object)(this.state() == null ? null : "*** Sensitive Data Redacted ***")).add("PostalCode", (Object)(this.postalCode() == null ? null : "*** Sensitive Data Redacted ***")).add("PostalCodePlus4", (Object)(this.postalCodePlus4() == null ? null : "*** Sensitive Data Redacted ***")).add("Country", (Object)(this.country() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streetName": {
                return Optional.ofNullable(clazz.cast(this.streetName()));
            }
            case "streetSuffix": {
                return Optional.ofNullable(clazz.cast(this.streetSuffix()));
            }
            case "postDirectional": {
                return Optional.ofNullable(clazz.cast(this.postDirectional()));
            }
            case "preDirectional": {
                return Optional.ofNullable(clazz.cast(this.preDirectional()));
            }
            case "streetNumber": {
                return Optional.ofNullable(clazz.cast(this.streetNumber()));
            }
            case "city": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "postalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "postalCodePlus4": {
                return Optional.ofNullable(clazz.cast(this.postalCodePlus4()));
            }
            case "country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("streetName", STREET_NAME_FIELD);
        map.put("streetSuffix", STREET_SUFFIX_FIELD);
        map.put("postDirectional", POST_DIRECTIONAL_FIELD);
        map.put("preDirectional", PRE_DIRECTIONAL_FIELD);
        map.put("streetNumber", STREET_NUMBER_FIELD);
        map.put("city", CITY_FIELD);
        map.put("state", STATE_FIELD);
        map.put("postalCode", POSTAL_CODE_FIELD);
        map.put("postalCodePlus4", POSTAL_CODE_PLUS4_FIELD);
        map.put("country", COUNTRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streetName;
        private String streetSuffix;
        private String postDirectional;
        private String preDirectional;
        private String streetNumber;
        private String city;
        private String state;
        private String postalCode;
        private String postalCodePlus4;
        private String country;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            this.streetName(model.streetName);
            this.streetSuffix(model.streetSuffix);
            this.postDirectional(model.postDirectional);
            this.preDirectional(model.preDirectional);
            this.streetNumber(model.streetNumber);
            this.city(model.city);
            this.state(model.state);
            this.postalCode(model.postalCode);
            this.postalCodePlus4(model.postalCodePlus4);
            this.country(model.country);
        }

        public final String getStreetName() {
            return this.streetName;
        }

        public final void setStreetName(String streetName) {
            this.streetName = streetName;
        }

        @Override
        public final Builder streetName(String streetName) {
            this.streetName = streetName;
            return this;
        }

        public final String getStreetSuffix() {
            return this.streetSuffix;
        }

        public final void setStreetSuffix(String streetSuffix) {
            this.streetSuffix = streetSuffix;
        }

        @Override
        public final Builder streetSuffix(String streetSuffix) {
            this.streetSuffix = streetSuffix;
            return this;
        }

        public final String getPostDirectional() {
            return this.postDirectional;
        }

        public final void setPostDirectional(String postDirectional) {
            this.postDirectional = postDirectional;
        }

        @Override
        public final Builder postDirectional(String postDirectional) {
            this.postDirectional = postDirectional;
            return this;
        }

        public final String getPreDirectional() {
            return this.preDirectional;
        }

        public final void setPreDirectional(String preDirectional) {
            this.preDirectional = preDirectional;
        }

        @Override
        public final Builder preDirectional(String preDirectional) {
            this.preDirectional = preDirectional;
            return this;
        }

        public final String getStreetNumber() {
            return this.streetNumber;
        }

        public final void setStreetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
        }

        @Override
        public final Builder streetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
            return this;
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getPostalCodePlus4() {
            return this.postalCodePlus4;
        }

        public final void setPostalCodePlus4(String postalCodePlus4) {
            this.postalCodePlus4 = postalCodePlus4;
        }

        @Override
        public final Builder postalCodePlus4(String postalCodePlus4) {
            this.postalCodePlus4 = postalCodePlus4;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public Address build() {
            return new Address(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Address> {
        public Builder streetName(String var1);

        public Builder streetSuffix(String var1);

        public Builder postDirectional(String var1);

        public Builder preDirectional(String var1);

        public Builder streetNumber(String var1);

        public Builder city(String var1);

        public Builder state(String var1);

        public Builder postalCode(String var1);

        public Builder postalCodePlus4(String var1);

        public Builder country(String var1);
    }
}

