/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.Attendee;
import software.amazon.awssdk.services.chime.model.AttendeeListCopier;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAttendeesResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListAttendeesResponse> {
    private static final SdkField<List<Attendee>> ATTENDEES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attendees").getter(ListAttendeesResponse.getter(ListAttendeesResponse::attendees)).setter(ListAttendeesResponse.setter(Builder::attendees)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendees").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attendee::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAttendeesResponse.getter(ListAttendeesResponse::nextToken)).setter(ListAttendeesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTENDEES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAttendeesResponse.memberNameToFieldInitializer();
    private final List<Attendee> attendees;
    private final String nextToken;

    private ListAttendeesResponse(BuilderImpl builder) {
        super(builder);
        this.attendees = builder.attendees;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAttendees() {
        return this.attendees != null && !(this.attendees instanceof SdkAutoConstructList);
    }

    public final List<Attendee> attendees() {
        return this.attendees;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttendees() ? this.attendees() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttendeesResponse)) {
            return false;
        }
        ListAttendeesResponse other = (ListAttendeesResponse)((Object)obj);
        return this.hasAttendees() == other.hasAttendees() && Objects.equals(this.attendees(), other.attendees()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAttendeesResponse").add("Attendees", this.hasAttendees() ? this.attendees() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attendees": {
                return Optional.ofNullable(clazz.cast(this.attendees()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Attendees", ATTENDEES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAttendeesResponse, T> g) {
        return obj -> g.apply((ListAttendeesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<Attendee> attendees = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttendeesResponse model) {
            super(model);
            this.attendees(model.attendees);
            this.nextToken(model.nextToken);
        }

        public final List<Attendee.Builder> getAttendees() {
            List<Attendee.Builder> result = AttendeeListCopier.copyToBuilder(this.attendees);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttendees(Collection<Attendee.BuilderImpl> attendees) {
            this.attendees = AttendeeListCopier.copyFromBuilder(attendees);
        }

        @Override
        public final Builder attendees(Collection<Attendee> attendees) {
            this.attendees = AttendeeListCopier.copy(attendees);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(Attendee ... attendees) {
            this.attendees(Arrays.asList(attendees));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(Consumer<Attendee.Builder> ... attendees) {
            this.attendees(Stream.of(attendees).map(c -> (Attendee)((Attendee.Builder)Attendee.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAttendeesResponse build() {
            return new ListAttendeesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAttendeesResponse> {
        public Builder attendees(Collection<Attendee> var1);

        public Builder attendees(Attendee ... var1);

        public Builder attendees(Consumer<Attendee.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

