/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.Meeting;
import software.amazon.awssdk.services.chime.model.MeetingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMeetingsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListMeetingsResponse> {
    private static final SdkField<List<Meeting>> MEETINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Meetings").getter(ListMeetingsResponse.getter(ListMeetingsResponse::meetings)).setter(ListMeetingsResponse.setter(Builder::meetings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Meetings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Meeting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMeetingsResponse.getter(ListMeetingsResponse::nextToken)).setter(ListMeetingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Meetings", MEETINGS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<Meeting> meetings;
    private final String nextToken;

    private ListMeetingsResponse(BuilderImpl builder) {
        super(builder);
        this.meetings = builder.meetings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMeetings() {
        return this.meetings != null && !(this.meetings instanceof SdkAutoConstructList);
    }

    public final List<Meeting> meetings() {
        return this.meetings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMeetings() ? this.meetings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMeetingsResponse)) {
            return false;
        }
        ListMeetingsResponse other = (ListMeetingsResponse)((Object)obj);
        return this.hasMeetings() == other.hasMeetings() && Objects.equals(this.meetings(), other.meetings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMeetingsResponse").add("Meetings", this.hasMeetings() ? this.meetings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Meetings": {
                return Optional.ofNullable(clazz.cast(this.meetings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListMeetingsResponse, T> g) {
        return obj -> g.apply((ListMeetingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<Meeting> meetings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMeetingsResponse model) {
            super(model);
            this.meetings(model.meetings);
            this.nextToken(model.nextToken);
        }

        public final List<Meeting.Builder> getMeetings() {
            List<Meeting.Builder> result = MeetingListCopier.copyToBuilder(this.meetings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMeetings(Collection<Meeting.BuilderImpl> meetings) {
            this.meetings = MeetingListCopier.copyFromBuilder(meetings);
        }

        @Override
        public final Builder meetings(Collection<Meeting> meetings) {
            this.meetings = MeetingListCopier.copy(meetings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder meetings(Meeting ... meetings) {
            this.meetings(Arrays.asList(meetings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder meetings(Consumer<Meeting.Builder> ... meetings) {
            this.meetings(Stream.of(meetings).map(c -> (Meeting)((Meeting.Builder)Meeting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMeetingsResponse build() {
            return new ListMeetingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMeetingsResponse> {
        public Builder meetings(Collection<Meeting> var1);

        public Builder meetings(Meeting ... var1);

        public Builder meetings(Consumer<Meeting.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

