/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeChannelModeratedByAppInstanceUserRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, DescribeChannelModeratedByAppInstanceUserRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(DescribeChannelModeratedByAppInstanceUserRequest.getter(DescribeChannelModeratedByAppInstanceUserRequest::channelArn)).setter(DescribeChannelModeratedByAppInstanceUserRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()}).build();
    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceUserArn").getter(DescribeChannelModeratedByAppInstanceUserRequest.getter(DescribeChannelModeratedByAppInstanceUserRequest::appInstanceUserArn)).setter(DescribeChannelModeratedByAppInstanceUserRequest.setter(Builder::appInstanceUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("app-instance-user-arn").build()}).build();
    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChimeBearer").getter(DescribeChannelModeratedByAppInstanceUserRequest.getter(DescribeChannelModeratedByAppInstanceUserRequest::chimeBearer)).setter(DescribeChannelModeratedByAppInstanceUserRequest.setter(Builder::chimeBearer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, APP_INSTANCE_USER_ARN_FIELD, CHIME_BEARER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("channelArn", CHANNEL_ARN_FIELD);
            this.put("app-instance-user-arn", APP_INSTANCE_USER_ARN_FIELD);
            this.put("x-amz-chime-bearer", CHIME_BEARER_FIELD);
        }
    });
    private final String channelArn;
    private final String appInstanceUserArn;
    private final String chimeBearer;

    private DescribeChannelModeratedByAppInstanceUserRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.chimeBearer = builder.chimeBearer;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String appInstanceUserArn() {
        return this.appInstanceUserArn;
    }

    public final String chimeBearer() {
        return this.chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.chimeBearer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChannelModeratedByAppInstanceUserRequest)) {
            return false;
        }
        DescribeChannelModeratedByAppInstanceUserRequest other = (DescribeChannelModeratedByAppInstanceUserRequest)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.appInstanceUserArn(), other.appInstanceUserArn()) && Objects.equals(this.chimeBearer(), other.chimeBearer());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeChannelModeratedByAppInstanceUserRequest").add("ChannelArn", (Object)this.channelArn()).add("AppInstanceUserArn", (Object)this.appInstanceUserArn()).add("ChimeBearer", (Object)this.chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "AppInstanceUserArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceUserArn()));
            }
            case "ChimeBearer": {
                return Optional.ofNullable(clazz.cast(this.chimeBearer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChannelModeratedByAppInstanceUserRequest, T> g) {
        return obj -> g.apply((DescribeChannelModeratedByAppInstanceUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String channelArn;
        private String appInstanceUserArn;
        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChannelModeratedByAppInstanceUserRequest model) {
            super(model);
            this.channelArn(model.channelArn);
            this.appInstanceUserArn(model.appInstanceUserArn);
            this.chimeBearer(model.chimeBearer);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getAppInstanceUserArn() {
            return this.appInstanceUserArn;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final String getChimeBearer() {
            return this.chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeChannelModeratedByAppInstanceUserRequest build() {
            return new DescribeChannelModeratedByAppInstanceUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeChannelModeratedByAppInstanceUserRequest> {
        public Builder channelArn(String var1);

        public Builder appInstanceUserArn(String var1);

        public Builder chimeBearer(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

