/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.StreamingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutVoiceConnectorStreamingConfigurationRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, PutVoiceConnectorStreamingConfigurationRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorId").getter(PutVoiceConnectorStreamingConfigurationRequest.getter(PutVoiceConnectorStreamingConfigurationRequest::voiceConnectorId)).setter(PutVoiceConnectorStreamingConfigurationRequest.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()}).build();
    private static final SdkField<StreamingConfiguration> STREAMING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamingConfiguration").getter(PutVoiceConnectorStreamingConfigurationRequest.getter(PutVoiceConnectorStreamingConfigurationRequest::streamingConfiguration)).setter(PutVoiceConnectorStreamingConfigurationRequest.setter(Builder::streamingConfiguration)).constructor(StreamingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, STREAMING_CONFIGURATION_FIELD));
    private final String voiceConnectorId;
    private final StreamingConfiguration streamingConfiguration;

    private PutVoiceConnectorStreamingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.streamingConfiguration = builder.streamingConfiguration;
    }

    public final String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public final StreamingConfiguration streamingConfiguration() {
        return this.streamingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorStreamingConfigurationRequest)) {
            return false;
        }
        PutVoiceConnectorStreamingConfigurationRequest other = (PutVoiceConnectorStreamingConfigurationRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(this.streamingConfiguration(), other.streamingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PutVoiceConnectorStreamingConfigurationRequest").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("StreamingConfiguration", (Object)this.streamingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "StreamingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.streamingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorStreamingConfigurationRequest, T> g) {
        return obj -> g.apply((PutVoiceConnectorStreamingConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private StreamingConfiguration streamingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorStreamingConfigurationRequest model) {
            super(model);
            this.voiceConnectorId(model.voiceConnectorId);
            this.streamingConfiguration(model.streamingConfiguration);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final StreamingConfiguration.Builder getStreamingConfiguration() {
            return this.streamingConfiguration != null ? this.streamingConfiguration.toBuilder() : null;
        }

        public final void setStreamingConfiguration(StreamingConfiguration.BuilderImpl streamingConfiguration) {
            this.streamingConfiguration = streamingConfiguration != null ? streamingConfiguration.build() : null;
        }

        @Override
        public final Builder streamingConfiguration(StreamingConfiguration streamingConfiguration) {
            this.streamingConfiguration = streamingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVoiceConnectorStreamingConfigurationRequest build() {
            return new PutVoiceConnectorStreamingConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutVoiceConnectorStreamingConfigurationRequest> {
        public Builder voiceConnectorId(String var1);

        public Builder streamingConfiguration(StreamingConfiguration var1);

        default public Builder streamingConfiguration(Consumer<StreamingConfiguration.Builder> streamingConfiguration) {
            return this.streamingConfiguration((StreamingConfiguration)((StreamingConfiguration.Builder)StreamingConfiguration.builder().applyMutation(streamingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

