/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccountType {
    TEAM("Team"),
    ENTERPRISE_DIRECTORY("EnterpriseDirectory"),
    ENTERPRISE_LWA("EnterpriseLWA"),
    ENTERPRISE_OIDC("EnterpriseOIDC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccountType> VALUE_MAP;
    private final String value;

    private AccountType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccountType> knownValues() {
        EnumSet<AccountType> knownValues = EnumSet.allOf(AccountType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccountType.class, AccountType::toString);
    }
}

