/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.internal.UserAgentUtils;
import software.amazon.awssdk.services.chime.model.ListChannelMessagesRequest;
import software.amazon.awssdk.services.chime.model.ListChannelMessagesResponse;

public class ListChannelMessagesIterable
implements SdkIterable<ListChannelMessagesResponse> {
    private final ChimeClient client;
    private final ListChannelMessagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelMessagesIterable(ChimeClient client, ListChannelMessagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChannelMessagesResponseFetcher();
    }

    public Iterator<ListChannelMessagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChannelMessagesResponseFetcher
    implements SyncPageFetcher<ListChannelMessagesResponse> {
        private ListChannelMessagesResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelMessagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelMessagesResponse nextPage(ListChannelMessagesResponse previousPage) {
            if (previousPage == null) {
                return ListChannelMessagesIterable.this.client.listChannelMessages(ListChannelMessagesIterable.this.firstRequest);
            }
            return ListChannelMessagesIterable.this.client.listChannelMessages((ListChannelMessagesRequest)((Object)ListChannelMessagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

