/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEventsConfigurationResponse extends ChimeResponse implements
        ToCopyableBuilder<PutEventsConfigurationResponse.Builder, PutEventsConfigurationResponse> {
    private static final SdkField<EventsConfiguration> EVENTS_CONFIGURATION_FIELD = SdkField
            .<EventsConfiguration> builder(MarshallingType.SDK_POJO).memberName("EventsConfiguration")
            .getter(getter(PutEventsConfigurationResponse::eventsConfiguration)).setter(setter(Builder::eventsConfiguration))
            .constructor(EventsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_CONFIGURATION_FIELD));

    private final EventsConfiguration eventsConfiguration;

    private PutEventsConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.eventsConfiguration = builder.eventsConfiguration;
    }

    /**
     * <p>
     * The configuration that allows a bot to receive outgoing events. Can be an HTTPS endpoint or an AWS Lambda
     * function ARN.
     * </p>
     * 
     * @return The configuration that allows a bot to receive outgoing events. Can be an HTTPS endpoint or an AWS Lambda
     *         function ARN.
     */
    public final EventsConfiguration eventsConfiguration() {
        return eventsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsConfigurationResponse)) {
            return false;
        }
        PutEventsConfigurationResponse other = (PutEventsConfigurationResponse) obj;
        return Objects.equals(eventsConfiguration(), other.eventsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutEventsConfigurationResponse").add("EventsConfiguration", eventsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventsConfiguration":
            return Optional.ofNullable(clazz.cast(eventsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventsConfigurationResponse, T> g) {
        return obj -> g.apply((PutEventsConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutEventsConfigurationResponse> {
        /**
         * <p>
         * The configuration that allows a bot to receive outgoing events. Can be an HTTPS endpoint or an AWS Lambda
         * function ARN.
         * </p>
         * 
         * @param eventsConfiguration
         *        The configuration that allows a bot to receive outgoing events. Can be an HTTPS endpoint or an AWS
         *        Lambda function ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsConfiguration(EventsConfiguration eventsConfiguration);

        /**
         * <p>
         * The configuration that allows a bot to receive outgoing events. Can be an HTTPS endpoint or an AWS Lambda
         * function ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventsConfiguration.Builder} avoiding the
         * need to create one manually via {@link EventsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #eventsConfiguration(EventsConfiguration)}.
         * 
         * @param eventsConfiguration
         *        a consumer that will call methods on {@link EventsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventsConfiguration(EventsConfiguration)
         */
        default Builder eventsConfiguration(Consumer<EventsConfiguration.Builder> eventsConfiguration) {
            return eventsConfiguration(EventsConfiguration.builder().applyMutation(eventsConfiguration).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private EventsConfiguration eventsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsConfigurationResponse model) {
            super(model);
            eventsConfiguration(model.eventsConfiguration);
        }

        public final EventsConfiguration.Builder getEventsConfiguration() {
            return eventsConfiguration != null ? eventsConfiguration.toBuilder() : null;
        }

        public final void setEventsConfiguration(EventsConfiguration.BuilderImpl eventsConfiguration) {
            this.eventsConfiguration = eventsConfiguration != null ? eventsConfiguration.build() : null;
        }

        @Override
        public final Builder eventsConfiguration(EventsConfiguration eventsConfiguration) {
            this.eventsConfiguration = eventsConfiguration;
            return this;
        }

        @Override
        public PutEventsConfigurationResponse build() {
            return new PutEventsConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
