/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.AudioMuxType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioArtifactsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioArtifactsConfiguration> {
    private static final SdkField<String> MUX_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MuxType").getter(AudioArtifactsConfiguration.getter(AudioArtifactsConfiguration::muxTypeAsString)).setter(AudioArtifactsConfiguration.setter(Builder::muxType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MuxType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MUX_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String muxType;

    private AudioArtifactsConfiguration(BuilderImpl builder) {
        this.muxType = builder.muxType;
    }

    public final AudioMuxType muxType() {
        return AudioMuxType.fromValue(this.muxType);
    }

    public final String muxTypeAsString() {
        return this.muxType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.muxTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioArtifactsConfiguration)) {
            return false;
        }
        AudioArtifactsConfiguration other = (AudioArtifactsConfiguration)obj;
        return Objects.equals(this.muxTypeAsString(), other.muxTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AudioArtifactsConfiguration").add("MuxType", (Object)this.muxTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MuxType": {
                return Optional.ofNullable(clazz.cast(this.muxTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioArtifactsConfiguration, T> g) {
        return obj -> g.apply((AudioArtifactsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String muxType;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioArtifactsConfiguration model) {
            this.muxType(model.muxType);
        }

        public final String getMuxType() {
            return this.muxType;
        }

        public final void setMuxType(String muxType) {
            this.muxType = muxType;
        }

        @Override
        public final Builder muxType(String muxType) {
            this.muxType = muxType;
            return this;
        }

        @Override
        public final Builder muxType(AudioMuxType muxType) {
            this.muxType(muxType == null ? null : muxType.toString());
            return this;
        }

        public AudioArtifactsConfiguration build() {
            return new AudioArtifactsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioArtifactsConfiguration> {
        public Builder muxType(String var1);

        public Builder muxType(AudioMuxType var1);
    }
}

