/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.MediaPlacement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Meeting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Meeting> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingId").getter(Meeting.getter(Meeting::meetingId)).setter(Meeting.setter(Builder::meetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingId").build()}).build();
    private static final SdkField<String> EXTERNAL_MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalMeetingId").getter(Meeting.getter(Meeting::externalMeetingId)).setter(Meeting.setter(Builder::externalMeetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalMeetingId").build()}).build();
    private static final SdkField<MediaPlacement> MEDIA_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaPlacement").getter(Meeting.getter(Meeting::mediaPlacement)).setter(Meeting.setter(Builder::mediaPlacement)).constructor(MediaPlacement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPlacement").build()}).build();
    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaRegion").getter(Meeting.getter(Meeting::mediaRegion)).setter(Meeting.setter(Builder::mediaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD, EXTERNAL_MEETING_ID_FIELD, MEDIA_PLACEMENT_FIELD, MEDIA_REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String meetingId;
    private final String externalMeetingId;
    private final MediaPlacement mediaPlacement;
    private final String mediaRegion;

    private Meeting(BuilderImpl builder) {
        this.meetingId = builder.meetingId;
        this.externalMeetingId = builder.externalMeetingId;
        this.mediaPlacement = builder.mediaPlacement;
        this.mediaRegion = builder.mediaRegion;
    }

    public final String meetingId() {
        return this.meetingId;
    }

    public final String externalMeetingId() {
        return this.externalMeetingId;
    }

    public final MediaPlacement mediaPlacement() {
        return this.mediaPlacement;
    }

    public final String mediaRegion() {
        return this.mediaRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPlacement());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Meeting)) {
            return false;
        }
        Meeting other = (Meeting)obj;
        return Objects.equals(this.meetingId(), other.meetingId()) && Objects.equals(this.externalMeetingId(), other.externalMeetingId()) && Objects.equals(this.mediaPlacement(), other.mediaPlacement()) && Objects.equals(this.mediaRegion(), other.mediaRegion());
    }

    public final String toString() {
        return ToString.builder((String)"Meeting").add("MeetingId", (Object)this.meetingId()).add("ExternalMeetingId", (Object)(this.externalMeetingId() == null ? null : "*** Sensitive Data Redacted ***")).add("MediaPlacement", (Object)this.mediaPlacement()).add("MediaRegion", (Object)this.mediaRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeetingId": {
                return Optional.ofNullable(clazz.cast(this.meetingId()));
            }
            case "ExternalMeetingId": {
                return Optional.ofNullable(clazz.cast(this.externalMeetingId()));
            }
            case "MediaPlacement": {
                return Optional.ofNullable(clazz.cast(this.mediaPlacement()));
            }
            case "MediaRegion": {
                return Optional.ofNullable(clazz.cast(this.mediaRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Meeting, T> g) {
        return obj -> g.apply((Meeting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String meetingId;
        private String externalMeetingId;
        private MediaPlacement mediaPlacement;
        private String mediaRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Meeting model) {
            this.meetingId(model.meetingId);
            this.externalMeetingId(model.externalMeetingId);
            this.mediaPlacement(model.mediaPlacement);
            this.mediaRegion(model.mediaRegion);
        }

        public final String getMeetingId() {
            return this.meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        @Transient
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final String getExternalMeetingId() {
            return this.externalMeetingId;
        }

        public final void setExternalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
        }

        @Override
        @Transient
        public final Builder externalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
            return this;
        }

        public final MediaPlacement.Builder getMediaPlacement() {
            return this.mediaPlacement != null ? this.mediaPlacement.toBuilder() : null;
        }

        public final void setMediaPlacement(MediaPlacement.BuilderImpl mediaPlacement) {
            this.mediaPlacement = mediaPlacement != null ? mediaPlacement.build() : null;
        }

        @Override
        @Transient
        public final Builder mediaPlacement(MediaPlacement mediaPlacement) {
            this.mediaPlacement = mediaPlacement;
            return this;
        }

        public final String getMediaRegion() {
            return this.mediaRegion;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        @Override
        @Transient
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public Meeting build() {
            return new Meeting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Meeting> {
        public Builder meetingId(String var1);

        public Builder externalMeetingId(String var1);

        public Builder mediaPlacement(MediaPlacement var1);

        default public Builder mediaPlacement(Consumer<MediaPlacement.Builder> mediaPlacement) {
            return this.mediaPlacement((MediaPlacement)((MediaPlacement.Builder)MediaPlacement.builder().applyMutation(mediaPlacement)).build());
        }

        public Builder mediaRegion(String var1);
    }
}

