/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AccountType {
    TEAM("Team"),
    ENTERPRISE_DIRECTORY("EnterpriseDirectory"),
    ENTERPRISE_LWA("EnterpriseLWA"),
    ENTERPRISE_OIDC("EnterpriseOIDC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AccountType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AccountType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccountType> knownValues() {
        return Stream.of(AccountType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

