/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.TranscribeLanguageCode;
import software.amazon.awssdk.services.chime.model.TranscribeRegion;
import software.amazon.awssdk.services.chime.model.TranscribeVocabularyFilterMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngineTranscribeSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngineTranscribeSettings> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::languageCodeAsString)).setter(EngineTranscribeSettings.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterMethod").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::vocabularyFilterMethodAsString)).setter(EngineTranscribeSettings.setter(Builder::vocabularyFilterMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::vocabularyFilterName)).setter(EngineTranscribeSettings.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::vocabularyName)).setter(EngineTranscribeSettings.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(EngineTranscribeSettings.getter(EngineTranscribeSettings::regionAsString)).setter(EngineTranscribeSettings.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD, VOCABULARY_FILTER_METHOD_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_NAME_FIELD, REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String languageCode;
    private final String vocabularyFilterMethod;
    private final String vocabularyFilterName;
    private final String vocabularyName;
    private final String region;

    private EngineTranscribeSettings(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyName = builder.vocabularyName;
        this.region = builder.region;
    }

    public final TranscribeLanguageCode languageCode() {
        return TranscribeLanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final TranscribeVocabularyFilterMethod vocabularyFilterMethod() {
        return TranscribeVocabularyFilterMethod.fromValue(this.vocabularyFilterMethod);
    }

    public final String vocabularyFilterMethodAsString() {
        return this.vocabularyFilterMethod;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final TranscribeRegion region() {
        return TranscribeRegion.fromValue(this.region);
    }

    public final String regionAsString() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineTranscribeSettings)) {
            return false;
        }
        EngineTranscribeSettings other = (EngineTranscribeSettings)obj;
        return Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString()) && Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.regionAsString(), other.regionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EngineTranscribeSettings").add("LanguageCode", (Object)this.languageCodeAsString()).add("VocabularyFilterMethod", (Object)this.vocabularyFilterMethodAsString()).add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("VocabularyName", (Object)this.vocabularyName()).add("Region", (Object)this.regionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "VocabularyFilterMethod": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMethodAsString()));
            }
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.regionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EngineTranscribeSettings, T> g) {
        return obj -> g.apply((EngineTranscribeSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private String vocabularyFilterMethod;
        private String vocabularyFilterName;
        private String vocabularyName;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineTranscribeSettings model) {
            this.languageCode(model.languageCode);
            this.vocabularyFilterMethod(model.vocabularyFilterMethod);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.vocabularyName(model.vocabularyName);
            this.region(model.region);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(TranscribeLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return this.vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(TranscribeVocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        @Transient
        public final Builder region(TranscribeRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public EngineTranscribeSettings build() {
            return new EngineTranscribeSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngineTranscribeSettings> {
        public Builder languageCode(String var1);

        public Builder languageCode(TranscribeLanguageCode var1);

        public Builder vocabularyFilterMethod(String var1);

        public Builder vocabularyFilterMethod(TranscribeVocabularyFilterMethod var1);

        public Builder vocabularyFilterName(String var1);

        public Builder vocabularyName(String var1);

        public Builder region(String var1);

        public Builder region(TranscribeRegion var1);
    }
}

