/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.ChimeSdkMeetingConfiguration;
import software.amazon.awssdk.services.chime.model.MediaPipelineSinkType;
import software.amazon.awssdk.services.chime.model.MediaPipelineSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMediaCapturePipelineRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, CreateMediaCapturePipelineRequest> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::sourceTypeAsString)).setter(CreateMediaCapturePipelineRequest.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::sourceArn)).setter(CreateMediaCapturePipelineRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> SINK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkType").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::sinkTypeAsString)).setter(CreateMediaCapturePipelineRequest.setter(Builder::sinkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkType").build()}).build();
    private static final SdkField<String> SINK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkArn").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::sinkArn)).setter(CreateMediaCapturePipelineRequest.setter(Builder::sinkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::clientRequestToken)).setter(CreateMediaCapturePipelineRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ChimeSdkMeetingConfiguration> CHIME_SDK_MEETING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChimeSdkMeetingConfiguration").getter(CreateMediaCapturePipelineRequest.getter(CreateMediaCapturePipelineRequest::chimeSdkMeetingConfiguration)).setter(CreateMediaCapturePipelineRequest.setter(Builder::chimeSdkMeetingConfiguration)).constructor(ChimeSdkMeetingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChimeSdkMeetingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, SOURCE_ARN_FIELD, SINK_TYPE_FIELD, SINK_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, CHIME_SDK_MEETING_CONFIGURATION_FIELD));
    private final String sourceType;
    private final String sourceArn;
    private final String sinkType;
    private final String sinkArn;
    private final String clientRequestToken;
    private final ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration;

    private CreateMediaCapturePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.sourceType = builder.sourceType;
        this.sourceArn = builder.sourceArn;
        this.sinkType = builder.sinkType;
        this.sinkArn = builder.sinkArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.chimeSdkMeetingConfiguration = builder.chimeSdkMeetingConfiguration;
    }

    public final MediaPipelineSourceType sourceType() {
        return MediaPipelineSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final MediaPipelineSinkType sinkType() {
        return MediaPipelineSinkType.fromValue(this.sinkType);
    }

    public final String sinkTypeAsString() {
        return this.sinkType;
    }

    public final String sinkArn() {
        return this.sinkArn;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration() {
        return this.chimeSdkMeetingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.chimeSdkMeetingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaCapturePipelineRequest)) {
            return false;
        }
        CreateMediaCapturePipelineRequest other = (CreateMediaCapturePipelineRequest)((Object)obj);
        return Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.sinkTypeAsString(), other.sinkTypeAsString()) && Objects.equals(this.sinkArn(), other.sinkArn()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.chimeSdkMeetingConfiguration(), other.chimeSdkMeetingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMediaCapturePipelineRequest").add("SourceType", (Object)this.sourceTypeAsString()).add("SourceArn", (Object)(this.sourceArn() == null ? null : "*** Sensitive Data Redacted ***")).add("SinkType", (Object)this.sinkTypeAsString()).add("SinkArn", (Object)(this.sinkArn() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ChimeSdkMeetingConfiguration", (Object)this.chimeSdkMeetingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "SinkType": {
                return Optional.ofNullable(clazz.cast(this.sinkTypeAsString()));
            }
            case "SinkArn": {
                return Optional.ofNullable(clazz.cast(this.sinkArn()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "ChimeSdkMeetingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chimeSdkMeetingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaCapturePipelineRequest, T> g) {
        return obj -> g.apply((CreateMediaCapturePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String sourceType;
        private String sourceArn;
        private String sinkType;
        private String sinkArn;
        private String clientRequestToken;
        private ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaCapturePipelineRequest model) {
            super(model);
            this.sourceType(model.sourceType);
            this.sourceArn(model.sourceArn);
            this.sinkType(model.sinkType);
            this.sinkArn(model.sinkArn);
            this.clientRequestToken(model.clientRequestToken);
            this.chimeSdkMeetingConfiguration(model.chimeSdkMeetingConfiguration);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        @Transient
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder sourceType(MediaPipelineSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        @Transient
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getSinkType() {
            return this.sinkType;
        }

        public final void setSinkType(String sinkType) {
            this.sinkType = sinkType;
        }

        @Override
        @Transient
        public final Builder sinkType(String sinkType) {
            this.sinkType = sinkType;
            return this;
        }

        @Override
        @Transient
        public final Builder sinkType(MediaPipelineSinkType sinkType) {
            this.sinkType(sinkType == null ? null : sinkType.toString());
            return this;
        }

        public final String getSinkArn() {
            return this.sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        @Transient
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final ChimeSdkMeetingConfiguration.Builder getChimeSdkMeetingConfiguration() {
            return this.chimeSdkMeetingConfiguration != null ? this.chimeSdkMeetingConfiguration.toBuilder() : null;
        }

        public final void setChimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration.BuilderImpl chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration != null ? chimeSdkMeetingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration chimeSdkMeetingConfiguration) {
            this.chimeSdkMeetingConfiguration = chimeSdkMeetingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMediaCapturePipelineRequest build() {
            return new CreateMediaCapturePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMediaCapturePipelineRequest> {
        public Builder sourceType(String var1);

        public Builder sourceType(MediaPipelineSourceType var1);

        public Builder sourceArn(String var1);

        public Builder sinkType(String var1);

        public Builder sinkType(MediaPipelineSinkType var1);

        public Builder sinkArn(String var1);

        public Builder clientRequestToken(String var1);

        public Builder chimeSdkMeetingConfiguration(ChimeSdkMeetingConfiguration var1);

        default public Builder chimeSdkMeetingConfiguration(Consumer<ChimeSdkMeetingConfiguration.Builder> chimeSdkMeetingConfiguration) {
            return this.chimeSdkMeetingConfiguration((ChimeSdkMeetingConfiguration)((ChimeSdkMeetingConfiguration.Builder)ChimeSdkMeetingConfiguration.builder().applyMutation(chimeSdkMeetingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

