/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSipMediaApplicationCallRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, CreateSipMediaApplicationCallRequest> {
    private static final SdkField<String> FROM_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromPhoneNumber").getter(CreateSipMediaApplicationCallRequest.getter(CreateSipMediaApplicationCallRequest::fromPhoneNumber)).setter(CreateSipMediaApplicationCallRequest.setter(Builder::fromPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPhoneNumber").build()}).build();
    private static final SdkField<String> TO_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ToPhoneNumber").getter(CreateSipMediaApplicationCallRequest.getter(CreateSipMediaApplicationCallRequest::toPhoneNumber)).setter(CreateSipMediaApplicationCallRequest.setter(Builder::toPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPhoneNumber").build()}).build();
    private static final SdkField<String> SIP_MEDIA_APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SipMediaApplicationId").getter(CreateSipMediaApplicationCallRequest.getter(CreateSipMediaApplicationCallRequest::sipMediaApplicationId)).setter(CreateSipMediaApplicationCallRequest.setter(Builder::sipMediaApplicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sipMediaApplicationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PHONE_NUMBER_FIELD, TO_PHONE_NUMBER_FIELD, SIP_MEDIA_APPLICATION_ID_FIELD));
    private final String fromPhoneNumber;
    private final String toPhoneNumber;
    private final String sipMediaApplicationId;

    private CreateSipMediaApplicationCallRequest(BuilderImpl builder) {
        super(builder);
        this.fromPhoneNumber = builder.fromPhoneNumber;
        this.toPhoneNumber = builder.toPhoneNumber;
        this.sipMediaApplicationId = builder.sipMediaApplicationId;
    }

    public final String fromPhoneNumber() {
        return this.fromPhoneNumber;
    }

    public final String toPhoneNumber() {
        return this.toPhoneNumber;
    }

    public final String sipMediaApplicationId() {
        return this.sipMediaApplicationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.sipMediaApplicationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSipMediaApplicationCallRequest)) {
            return false;
        }
        CreateSipMediaApplicationCallRequest other = (CreateSipMediaApplicationCallRequest)((Object)obj);
        return Objects.equals(this.fromPhoneNumber(), other.fromPhoneNumber()) && Objects.equals(this.toPhoneNumber(), other.toPhoneNumber()) && Objects.equals(this.sipMediaApplicationId(), other.sipMediaApplicationId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSipMediaApplicationCallRequest").add("FromPhoneNumber", (Object)(this.fromPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("ToPhoneNumber", (Object)(this.toPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("SipMediaApplicationId", (Object)this.sipMediaApplicationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.fromPhoneNumber()));
            }
            case "ToPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.toPhoneNumber()));
            }
            case "SipMediaApplicationId": {
                return Optional.ofNullable(clazz.cast(this.sipMediaApplicationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSipMediaApplicationCallRequest, T> g) {
        return obj -> g.apply((CreateSipMediaApplicationCallRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String fromPhoneNumber;
        private String toPhoneNumber;
        private String sipMediaApplicationId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSipMediaApplicationCallRequest model) {
            super(model);
            this.fromPhoneNumber(model.fromPhoneNumber);
            this.toPhoneNumber(model.toPhoneNumber);
            this.sipMediaApplicationId(model.sipMediaApplicationId);
        }

        public final String getFromPhoneNumber() {
            return this.fromPhoneNumber;
        }

        @Override
        public final Builder fromPhoneNumber(String fromPhoneNumber) {
            this.fromPhoneNumber = fromPhoneNumber;
            return this;
        }

        public final void setFromPhoneNumber(String fromPhoneNumber) {
            this.fromPhoneNumber = fromPhoneNumber;
        }

        public final String getToPhoneNumber() {
            return this.toPhoneNumber;
        }

        @Override
        public final Builder toPhoneNumber(String toPhoneNumber) {
            this.toPhoneNumber = toPhoneNumber;
            return this;
        }

        public final void setToPhoneNumber(String toPhoneNumber) {
            this.toPhoneNumber = toPhoneNumber;
        }

        public final String getSipMediaApplicationId() {
            return this.sipMediaApplicationId;
        }

        @Override
        public final Builder sipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
            return this;
        }

        public final void setSipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSipMediaApplicationCallRequest build() {
            return new CreateSipMediaApplicationCallRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSipMediaApplicationCallRequest> {
        public Builder fromPhoneNumber(String var1);

        public Builder toPhoneNumber(String var1);

        public Builder sipMediaApplicationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

