/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedactChannelMessageRequest extends ChimeRequest implements
        ToCopyableBuilder<RedactChannelMessageRequest.Builder, RedactChannelMessageRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(RedactChannelMessageRequest::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(RedactChannelMessageRequest::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageId").build()).build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(RedactChannelMessageRequest::chimeBearer))
            .setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            MESSAGE_ID_FIELD, CHIME_BEARER_FIELD));

    private final String channelArn;

    private final String messageId;

    private final String chimeBearer;

    private RedactChannelMessageRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.messageId = builder.messageId;
        this.chimeBearer = builder.chimeBearer;
    }

    /**
     * <p>
     * The ARN of the channel containing the messages that you want to redact.
     * </p>
     * 
     * @return The ARN of the channel containing the messages that you want to redact.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The ID of the message being redacted.
     * </p>
     * 
     * @return The ID of the message being redacted.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     * 
     * @return The <code>AppInstanceUserArn</code> of the user that makes the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedactChannelMessageRequest)) {
            return false;
        }
        RedactChannelMessageRequest other = (RedactChannelMessageRequest) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(messageId(), other.messageId())
                && Objects.equals(chimeBearer(), other.chimeBearer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedactChannelMessageRequest").add("ChannelArn", channelArn()).add("MessageId", messageId())
                .add("ChimeBearer", chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedactChannelMessageRequest, T> g) {
        return obj -> g.apply((RedactChannelMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, RedactChannelMessageRequest> {
        /**
         * <p>
         * The ARN of the channel containing the messages that you want to redact.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel containing the messages that you want to redact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The ID of the message being redacted.
         * </p>
         * 
         * @param messageId
         *        The ID of the message being redacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String channelArn;

        private String messageId;

        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(RedactChannelMessageRequest model) {
            super(model);
            channelArn(model.channelArn);
            messageId(model.messageId);
            chimeBearer(model.chimeBearer);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        public final String getMessageId() {
            return messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RedactChannelMessageRequest build() {
            return new RedactChannelMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
