/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSipRuleRequest extends ChimeRequest implements
        ToCopyableBuilder<CreateSipRuleRequest.Builder, CreateSipRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateSipRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TRIGGER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TriggerType").getter(getter(CreateSipRuleRequest::triggerTypeAsString))
            .setter(setter(Builder::triggerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerType").build()).build();

    private static final SdkField<String> TRIGGER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TriggerValue").getter(getter(CreateSipRuleRequest::triggerValue)).setter(setter(Builder::triggerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerValue").build()).build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled").getter(getter(CreateSipRuleRequest::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final SdkField<List<SipRuleTargetApplication>> TARGET_APPLICATIONS_FIELD = SdkField
            .<List<SipRuleTargetApplication>> builder(MarshallingType.LIST)
            .memberName("TargetApplications")
            .getter(getter(CreateSipRuleRequest::targetApplications))
            .setter(setter(Builder::targetApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SipRuleTargetApplication> builder(MarshallingType.SDK_POJO)
                                            .constructor(SipRuleTargetApplication::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TRIGGER_TYPE_FIELD, TRIGGER_VALUE_FIELD, DISABLED_FIELD, TARGET_APPLICATIONS_FIELD));

    private final String name;

    private final String triggerType;

    private final String triggerValue;

    private final Boolean disabled;

    private final List<SipRuleTargetApplication> targetApplications;

    private CreateSipRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.triggerType = builder.triggerType;
        this.triggerValue = builder.triggerValue;
        this.disabled = builder.disabled;
        this.targetApplications = builder.targetApplications;
    }

    /**
     * <p>
     * The name of the SIP rule.
     * </p>
     * 
     * @return The name of the SIP rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently
     * <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link SipRuleTriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently
     *         <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.
     * @see SipRuleTriggerType
     */
    public final SipRuleTriggerType triggerType() {
        return SipRuleTriggerType.fromValue(triggerType);
    }

    /**
     * <p>
     * The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently
     * <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link SipRuleTriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently
     *         <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.
     * @see SipRuleTriggerType
     */
    public final String triggerTypeAsString() {
        return triggerType;
    }

    /**
     * <p>
     * If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host name of an
     * Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, the value can be a
     * customer-owned phone number in the E164 format. The <code>SipMediaApplication</code> specified in the
     * <code>SipRule</code> is triggered if the request URI in an incoming SIP request matches the
     * <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the
     * <code>ToPhoneNumber</code> value.
     * </p>
     * 
     * @return If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host name
     *         of an Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, the value
     *         can be a customer-owned phone number in the E164 format. The <code>SipMediaApplication</code> specified
     *         in the <code>SipRule</code> is triggered if the request URI in an incoming SIP request matches the
     *         <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the
     *         <code>ToPhoneNumber</code> value.
     */
    public final String triggerValue() {
        return triggerValue;
    }

    /**
     * <p>
     * Enables or disables a rule. You must disable rules before you can delete them.
     * </p>
     * 
     * @return Enables or disables a rule. You must disable rules before you can delete them.
     */
    public final Boolean disabled() {
        return disabled;
    }

    /**
     * Returns true if the TargetApplications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTargetApplications() {
        return targetApplications != null && !(targetApplications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetApplications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can
     *         be used.
     */
    public final List<SipRuleTargetApplication> targetApplications() {
        return targetApplications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(triggerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(triggerValue());
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetApplications() ? targetApplications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSipRuleRequest)) {
            return false;
        }
        CreateSipRuleRequest other = (CreateSipRuleRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(triggerTypeAsString(), other.triggerTypeAsString())
                && Objects.equals(triggerValue(), other.triggerValue()) && Objects.equals(disabled(), other.disabled())
                && hasTargetApplications() == other.hasTargetApplications()
                && Objects.equals(targetApplications(), other.targetApplications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSipRuleRequest").add("Name", name()).add("TriggerType", triggerTypeAsString())
                .add("TriggerValue", triggerValue()).add("Disabled", disabled())
                .add("TargetApplications", hasTargetApplications() ? targetApplications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TriggerType":
            return Optional.ofNullable(clazz.cast(triggerTypeAsString()));
        case "TriggerValue":
            return Optional.ofNullable(clazz.cast(triggerValue()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        case "TargetApplications":
            return Optional.ofNullable(clazz.cast(targetApplications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSipRuleRequest, T> g) {
        return obj -> g.apply((CreateSipRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSipRuleRequest> {
        /**
         * <p>
         * The name of the SIP rule.
         * </p>
         * 
         * @param name
         *        The name of the SIP rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently
         * <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.
         * </p>
         * 
         * @param triggerType
         *        The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently
         *        <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.
         * @see SipRuleTriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SipRuleTriggerType
         */
        Builder triggerType(String triggerType);

        /**
         * <p>
         * The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently
         * <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.
         * </p>
         * 
         * @param triggerType
         *        The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently
         *        <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.
         * @see SipRuleTriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SipRuleTriggerType
         */
        Builder triggerType(SipRuleTriggerType triggerType);

        /**
         * <p>
         * If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host name of an
         * Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, the value can be a
         * customer-owned phone number in the E164 format. The <code>SipMediaApplication</code> specified in the
         * <code>SipRule</code> is triggered if the request URI in an incoming SIP request matches the
         * <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the
         * <code>ToPhoneNumber</code> value.
         * </p>
         * 
         * @param triggerValue
         *        If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host
         *        name of an Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>,
         *        the value can be a customer-owned phone number in the E164 format. The
         *        <code>SipMediaApplication</code> specified in the <code>SipRule</code> is triggered if the request URI
         *        in an incoming SIP request matches the <code>RequestUriHostname</code>, or if the <code>To</code>
         *        header in the incoming SIP request matches the <code>ToPhoneNumber</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerValue(String triggerValue);

        /**
         * <p>
         * Enables or disables a rule. You must disable rules before you can delete them.
         * </p>
         * 
         * @param disabled
         *        Enables or disables a rule. You must disable rules before you can delete them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);

        /**
         * <p>
         * List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be
         * used.
         * </p>
         * 
         * @param targetApplications
         *        List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region
         *        can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetApplications(Collection<SipRuleTargetApplication> targetApplications);

        /**
         * <p>
         * List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be
         * used.
         * </p>
         * 
         * @param targetApplications
         *        List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region
         *        can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetApplications(SipRuleTargetApplication... targetApplications);

        /**
         * <p>
         * List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be
         * used.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SipRuleTargetApplication>.Builder} avoiding
         * the need to create one manually via {@link List<SipRuleTargetApplication>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SipRuleTargetApplication>.Builder#build()} is called
         * immediately and its result is passed to {@link #targetApplications(List<SipRuleTargetApplication>)}.
         * 
         * @param targetApplications
         *        a consumer that will call methods on {@link List<SipRuleTargetApplication>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetApplications(List<SipRuleTargetApplication>)
         */
        Builder targetApplications(Consumer<SipRuleTargetApplication.Builder>... targetApplications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String name;

        private String triggerType;

        private String triggerValue;

        private Boolean disabled;

        private List<SipRuleTargetApplication> targetApplications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSipRuleRequest model) {
            super(model);
            name(model.name);
            triggerType(model.triggerType);
            triggerValue(model.triggerValue);
            disabled(model.disabled);
            targetApplications(model.targetApplications);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTriggerType() {
            return triggerType;
        }

        @Override
        public final Builder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Override
        public final Builder triggerType(SipRuleTriggerType triggerType) {
            this.triggerType(triggerType == null ? null : triggerType.toString());
            return this;
        }

        public final void setTriggerType(String triggerType) {
            this.triggerType = triggerType;
        }

        public final String getTriggerValue() {
            return triggerValue;
        }

        @Override
        public final Builder triggerValue(String triggerValue) {
            this.triggerValue = triggerValue;
            return this;
        }

        public final void setTriggerValue(String triggerValue) {
            this.triggerValue = triggerValue;
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        public final Collection<SipRuleTargetApplication.Builder> getTargetApplications() {
            if (targetApplications instanceof SdkAutoConstructList) {
                return null;
            }
            return targetApplications != null ? targetApplications.stream().map(SipRuleTargetApplication::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetApplications(Collection<SipRuleTargetApplication> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copy(targetApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(SipRuleTargetApplication... targetApplications) {
            targetApplications(Arrays.asList(targetApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetApplications(Consumer<SipRuleTargetApplication.Builder>... targetApplications) {
            targetApplications(Stream.of(targetApplications)
                    .map(c -> SipRuleTargetApplication.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetApplications(Collection<SipRuleTargetApplication.BuilderImpl> targetApplications) {
            this.targetApplications = SipRuleTargetApplicationListCopier.copyFromBuilder(targetApplications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSipRuleRequest build() {
            return new CreateSipRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
