/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateUserRequest extends ChimeRequest implements
        ToCopyableBuilder<BatchUpdateUserRequest.Builder, BatchUpdateUserRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(BatchUpdateUserRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()).build();

    private static final SdkField<List<UpdateUserRequestItem>> UPDATE_USER_REQUEST_ITEMS_FIELD = SdkField
            .<List<UpdateUserRequestItem>> builder(MarshallingType.LIST)
            .memberName("UpdateUserRequestItems")
            .getter(getter(BatchUpdateUserRequest::updateUserRequestItems))
            .setter(setter(Builder::updateUserRequestItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateUserRequestItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateUserRequestItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateUserRequestItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            UPDATE_USER_REQUEST_ITEMS_FIELD));

    private final String accountId;

    private final List<UpdateUserRequestItem> updateUserRequestItems;

    private BatchUpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.updateUserRequestItems = builder.updateUserRequestItems;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * Returns true if the UpdateUserRequestItems property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUpdateUserRequestItems() {
        return updateUserRequestItems != null && !(updateUserRequestItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The request containing the user IDs and details to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpdateUserRequestItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The request containing the user IDs and details to update.
     */
    public final List<UpdateUserRequestItem> updateUserRequestItems() {
        return updateUserRequestItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdateUserRequestItems() ? updateUserRequestItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateUserRequest)) {
            return false;
        }
        BatchUpdateUserRequest other = (BatchUpdateUserRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && hasUpdateUserRequestItems() == other.hasUpdateUserRequestItems()
                && Objects.equals(updateUserRequestItems(), other.updateUserRequestItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateUserRequest").add("AccountId", accountId())
                .add("UpdateUserRequestItems", hasUpdateUserRequestItems() ? updateUserRequestItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "UpdateUserRequestItems":
            return Optional.ofNullable(clazz.cast(updateUserRequestItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateUserRequest, T> g) {
        return obj -> g.apply((BatchUpdateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateUserRequest> {
        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The request containing the user IDs and details to update.
         * </p>
         * 
         * @param updateUserRequestItems
         *        The request containing the user IDs and details to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateUserRequestItems(Collection<UpdateUserRequestItem> updateUserRequestItems);

        /**
         * <p>
         * The request containing the user IDs and details to update.
         * </p>
         * 
         * @param updateUserRequestItems
         *        The request containing the user IDs and details to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateUserRequestItems(UpdateUserRequestItem... updateUserRequestItems);

        /**
         * <p>
         * The request containing the user IDs and details to update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UpdateUserRequestItem>.Builder} avoiding
         * the need to create one manually via {@link List<UpdateUserRequestItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateUserRequestItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #updateUserRequestItems(List<UpdateUserRequestItem>)}.
         * 
         * @param updateUserRequestItems
         *        a consumer that will call methods on {@link List<UpdateUserRequestItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateUserRequestItems(List<UpdateUserRequestItem>)
         */
        Builder updateUserRequestItems(Consumer<UpdateUserRequestItem.Builder>... updateUserRequestItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String accountId;

        private List<UpdateUserRequestItem> updateUserRequestItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateUserRequest model) {
            super(model);
            accountId(model.accountId);
            updateUserRequestItems(model.updateUserRequestItems);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Collection<UpdateUserRequestItem.Builder> getUpdateUserRequestItems() {
            if (updateUserRequestItems instanceof SdkAutoConstructList) {
                return null;
            }
            return updateUserRequestItems != null ? updateUserRequestItems.stream().map(UpdateUserRequestItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updateUserRequestItems(Collection<UpdateUserRequestItem> updateUserRequestItems) {
            this.updateUserRequestItems = UpdateUserRequestItemListCopier.copy(updateUserRequestItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateUserRequestItems(UpdateUserRequestItem... updateUserRequestItems) {
            updateUserRequestItems(Arrays.asList(updateUserRequestItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateUserRequestItems(Consumer<UpdateUserRequestItem.Builder>... updateUserRequestItems) {
            updateUserRequestItems(Stream.of(updateUserRequestItems)
                    .map(c -> UpdateUserRequestItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdateUserRequestItems(Collection<UpdateUserRequestItem.BuilderImpl> updateUserRequestItems) {
            this.updateUserRequestItems = UpdateUserRequestItemListCopier.copyFromBuilder(updateUserRequestItems);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateUserRequest build() {
            return new BatchUpdateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
